/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.handler;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.CuboidDTO;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.Others;
import cn.lunadeer.dominion.utils.BorderRenderUtil;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.VaultConnect.VaultConnect;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SelectPointEventsHandler
implements Listener {
    public SelectPointEventsHandler(JavaPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void selectPoint(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.matchMaterial((String)Configuration.selectTool)) {
            return;
        }
        Block block = event.getClickedBlock();
        Action action = event.getAction();
        if (block == null) {
            return;
        }
        Map<Integer, Location> points = Dominion.pointsSelect.get(player.getUniqueId());
        if (points == null) {
            points = new HashMap<Integer, Location>();
        }
        if (action == Action.LEFT_CLICK_BLOCK) {
            event.setCancelled(true);
            Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.firstPoint, block.getX(), block.getY(), block.getZ());
            loc = block.getLocation();
            if (Configuration.getPlayerLimitation((Player)player).getWorldSettings((World)player.getWorld()).autoIncludeVertical) {
                loc.setY((double)Configuration.getPlayerLimitation((Player)player).getWorldSettings((World)player.getWorld()).noLowerThan);
            }
            points.put(0, loc);
        } else if (action == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
            Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.secondPoint, block.getX(), block.getY(), block.getZ());
            loc = block.getLocation();
            if (Configuration.getPlayerLimitation((Player)player).getWorldSettings((World)player.getWorld()).autoIncludeVertical) {
                loc.setY((double)(Configuration.getPlayerLimitation((Player)player).getWorldSettings((World)player.getWorld()).noHigherThan - 1));
            }
            points.put(1, loc);
        } else {
            return;
        }
        Dominion.pointsSelect.put(player.getUniqueId(), points);
        if (points.size() == 2) {
            World world = points.get(0).getWorld();
            if (world == null) {
                return;
            }
            if (!points.get(0).getWorld().getUID().equals(points.get(1).getWorld().getUID())) {
                Notification.warn((CommandSender)player, Language.selectPointEventsHandlerText.notSameWorld);
                return;
            }
            Location[] locs = Others.sortLocations(points.get(0), points.get(1));
            CuboidDTO cuboid = new CuboidDTO(locs[0], locs[1]);
            try {
                if (Configuration.getPlayerLimitation((Player)player).economy.enable) {
                    long amount = Configuration.getPlayerLimitation((Player)player).economy.squareOnly ? cuboid.getSquare() : cuboid.getVolume();
                    double price = (double)amount * Configuration.getPlayerLimitation((Player)player).economy.pricePerBlock;
                    Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.price, price, VaultConnect.instance.currencyNamePlural());
                }
                BorderRenderUtil.showBorder(player, points.get(0).getWorld(), cuboid, BorderRenderUtil.DEFAULT_GLOW_COLOR);
                Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.size, cuboid.xLength(), cuboid.yLength(), cuboid.zLength());
                Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.square, cuboid.getSquare());
                Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.volume, cuboid.getVolume());
            }
            catch (Exception e) {
                Notification.error((CommandSender)player, e.getMessage());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void selectBlockToShowInfo(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.matchMaterial((String)Configuration.infoTool)) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        event.setCancelled(true);
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        DominionDTO dominion = CacheManager.instance.getDominion(block.getLocation());
        if (dominion == null) {
            Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.noDominion, block.getX(), block.getY(), block.getZ());
        } else {
            Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.foundDominion, block.getX(), block.getY(), block.getZ(), dominion.getName());
            CuboidDTO cuboid = dominion.getCuboid();
            Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.owner, CacheManager.instance.getPlayerName(dominion.getOwner()));
            Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.size, cuboid.xLength(), cuboid.yLength(), cuboid.zLength());
            Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.square, cuboid.getSquare());
            Notification.info((CommandSender)player, Language.selectPointEventsHandlerText.volume, cuboid.getVolume());
            BorderRenderUtil.showBorder(player, dominion);
        }
    }

    public static class SelectPointEventsHandlerText
    extends ConfigurationPart {
        public String firstPoint = "First point selected at {0}, {1}, {2}.";
        public String secondPoint = "Second point selected at {0}, {1}, {2}.";
        public String notSameWorld = "The two points are not in the same world.";
        public String price = "The price of the dominion is {0} {1}.";
        public String owner = "Owner: {0}";
        public String size = "Size: {0}x{1}x{2}";
        public String square = "Square: {0}";
        public String volume = "Volume: {0}";
        public String noDominion = "No dominion found at the location {0}, {1}, {2}.";
        public String foundDominion = "Location {0}, {1}, {2} is in dominion {3}.";
    }
}

