/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.events.group;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.events.ResultEvent;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class GroupSetFlagEvent
extends ResultEvent {
    private final DominionDTO dominion;
    private final PriFlag flag;
    private final boolean oldValue;
    private boolean newValue;
    private final GroupDTO group;
    private final CompletableFuture<GroupDTO> future = new CompletableFuture();

    public GroupSetFlagEvent(@NotNull CommandSender operator, @NotNull DominionDTO dominion, @NotNull GroupDTO group, @NotNull PriFlag flag, boolean newValue) {
        super(operator);
        this.dominion = dominion;
        this.flag = flag;
        this.oldValue = group.getFlagValue(flag);
        this.newValue = newValue;
        this.group = group;
    }

    @NotNull
    public DominionDTO getDominion() {
        return this.dominion;
    }

    public PriFlag getFlag() {
        return this.flag;
    }

    public boolean getOldValue() {
        return this.oldValue;
    }

    public boolean getNewValue() {
        return this.newValue;
    }

    public void setNewValue(boolean newValue) {
        this.newValue = newValue;
    }

    public GroupDTO getGroup() {
        return this.group;
    }

    public CompletableFuture<GroupDTO> getFutureToComplete() {
        return this.future;
    }

    public CompletableFuture<Void> afterSet(Consumer<GroupDTO> consumer) {
        return this.future.thenAccept((Consumer)consumer);
    }
}

