/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.DominionNode;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.utils.AutoTimer;
import cn.lunadeer.dominion.utils.XLogger;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class DominionNodeSectored {
    private volatile Snapshot snapshot = Snapshot.empty();

    public DominionDTO getDominionByLocation(@NotNull Location loc) {
        try (AutoTimer ignored = new AutoTimer(Configuration.timer);){
            CopyOnWriteArrayList<DominionNode> nodes = this.getNodes(loc);
            if (nodes == null) {
                DominionDTO dominionDTO = null;
                return dominionDTO;
            }
            if (nodes.isEmpty()) {
                DominionDTO dominionDTO = null;
                return dominionDTO;
            }
            DominionNode dominionNode = DominionNode.getDominionNodeByLocation(nodes, loc);
            DominionDTO dominionDTO = dominionNode == null ? null : dominionNode.getDominion();
            return dominionDTO;
        }
    }

    public CopyOnWriteArrayList<DominionNode> getNodes(@NotNull Location loc) {
        return this.getNodes(loc.getWorld().getUID(), loc.getBlockX(), loc.getBlockZ());
    }

    public CopyOnWriteArrayList<DominionNode> getNodes(World world, int x, int z) {
        return this.getNodes(world.getUID(), x, z);
    }

    public CopyOnWriteArrayList<DominionNode> getNodes(UUID world, int x, int z) {
        Snapshot current = this.snapshot;
        if (x >= current.originX && z >= current.originZ) {
            return current.sectorA.get(world);
        }
        if (x <= current.originX && z >= current.originZ) {
            return current.sectorB.get(world);
        }
        if (x >= current.originX) {
            return current.sectorC.get(world);
        }
        return current.sectorD.get(world);
    }

    public CompletableFuture<Void> buildAsync(CopyOnWriteArrayList<DominionNode> nodes) {
        return CompletableFuture.runAsync(() -> {
            try (AutoTimer ignored = new AutoTimer(Configuration.timer);){
                ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorA = new ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>>();
                ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorB = new ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>>();
                ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorC = new ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>>();
                ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorD = new ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>>();
                int max_x = nodes.parallelStream().mapToInt(n -> n.getDominion().getCuboid().x2()).max().orElse(0);
                int min_x = nodes.parallelStream().mapToInt(n -> n.getDominion().getCuboid().x1()).min().orElse(0);
                int max_z = nodes.parallelStream().mapToInt(n -> n.getDominion().getCuboid().z2()).max().orElse(0);
                int min_z = nodes.parallelStream().mapToInt(n -> n.getDominion().getCuboid().z1()).min().orElse(0);
                int tempOriginX = (max_x + min_x) / 2;
                int tempOriginZ = (max_z + min_z) / 2;
                XLogger.debug("Cache init section origin: {0}, {1}", tempOriginX, tempOriginZ);
                nodes.parallelStream().forEach(n -> {
                    DominionDTO d = n.getDominion();
                    tempSectorA.computeIfAbsent(d.getWorldUid(), k -> new CopyOnWriteArrayList());
                    tempSectorB.computeIfAbsent(d.getWorldUid(), k -> new CopyOnWriteArrayList());
                    tempSectorC.computeIfAbsent(d.getWorldUid(), k -> new CopyOnWriteArrayList());
                    tempSectorD.computeIfAbsent(d.getWorldUid(), k -> new CopyOnWriteArrayList());
                    this.placeDominionInSectors((DominionNode)n, d, tempOriginX, tempOriginZ, tempSectorA, tempSectorB, tempSectorC, tempSectorD);
                });
                this.snapshot = new Snapshot(tempSectorA, tempSectorB, tempSectorC, tempSectorD, tempOriginX, tempOriginZ);
            }
        }, ForkJoinPool.commonPool());
    }

    private void placeDominionInSectors(DominionNode n, DominionDTO d, int tempOriginX, int tempOriginZ, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorA, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorB, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorC, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorD) {
        if (d.getCuboid().x1() >= tempOriginX && d.getCuboid().z1() >= tempOriginZ) {
            tempSectorA.get(d.getWorldUid()).add(n);
        } else if (d.getCuboid().x1() <= tempOriginX && d.getCuboid().z1() >= tempOriginZ) {
            if (d.getCuboid().x2() >= tempOriginX) {
                tempSectorA.get(d.getWorldUid()).add(n);
                tempSectorB.get(d.getWorldUid()).add(n);
            } else {
                tempSectorB.get(d.getWorldUid()).add(n);
            }
        } else if (d.getCuboid().x1() >= tempOriginX && d.getCuboid().z1() <= tempOriginZ) {
            if (d.getCuboid().z2() >= tempOriginZ) {
                tempSectorA.get(d.getWorldUid()).add(n);
                tempSectorC.get(d.getWorldUid()).add(n);
            } else {
                tempSectorC.get(d.getWorldUid()).add(n);
            }
        } else if (d.getCuboid().x2() >= tempOriginX && d.getCuboid().z2() >= tempOriginZ) {
            tempSectorA.get(d.getWorldUid()).add(n);
            tempSectorB.get(d.getWorldUid()).add(n);
            tempSectorC.get(d.getWorldUid()).add(n);
            tempSectorD.get(d.getWorldUid()).add(n);
        } else if (d.getCuboid().x2() >= tempOriginX && d.getCuboid().z2() <= tempOriginZ) {
            tempSectorC.get(d.getWorldUid()).add(n);
            tempSectorD.get(d.getWorldUid()).add(n);
        } else if (d.getCuboid().z2() >= tempOriginZ && d.getCuboid().x2() <= tempOriginX) {
            tempSectorB.get(d.getWorldUid()).add(n);
            tempSectorD.get(d.getWorldUid()).add(n);
        } else {
            tempSectorD.get(d.getWorldUid()).add(n);
        }
    }

    private record Snapshot(ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> sectorA, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> sectorB, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> sectorC, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> sectorD, int originX, int originZ) {
        private static Snapshot empty() {
            return new Snapshot(new ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>>(), new ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>>(), new ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>>(), new ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>>(), 0, 0);
        }
    }
}

