/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import cn.lunadeer.dominion.utils.XLogger;

public class AutoTimer
implements AutoCloseable {
    private long startTime;
    private String callerInfo;
    private final boolean enable;

    public AutoTimer(boolean enable) {
        this.enable = enable;
        if (!enable) {
            return;
        }
        this.startTime = System.nanoTime();
        this.callerInfo = this.getCallerInfo();
    }

    public AutoTimer() {
        this(true);
    }

    private String getCallerInfo() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement element = stackTrace[3];
        return "Caller: " + element.getClassName() + "." + element.getMethodName() + " (" + element.getFileName() + ":" + element.getLineNumber() + ")";
    }

    @Override
    public void close() {
        if (!this.enable) {
            return;
        }
        long endTime = System.nanoTime();
        long duration = endTime - this.startTime;
        double durationInMillis = (double)duration / 1000000.0;
        XLogger.info("%s TimeSpan: %.3f ms (%d ns)", this.callerInfo, durationInMillis, duration);
    }
}

