/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.hooks;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.misc.Others;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderAPIHook
extends PlaceholderExpansion {
    private final JavaPlugin plugin;
    public static PlaceholderAPIHook instance = null;

    public PlaceholderAPIHook(JavaPlugin plugin) {
        this.plugin = plugin;
        this.register();
        instance = this;
    }

    public static String setPlaceholders(Player player, String text) {
        if (instance == null) {
            return text;
        }
        return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
    }

    public String onPlaceholderRequest(Player bukkitPlayer, @NotNull String params) {
        if (params.equalsIgnoreCase("group_title")) {
            Integer usingId = CacheManager.instance.getPlayerCache().getPlayerUsingTitleId(bukkitPlayer.getUniqueId());
            GroupDTO group = CacheManager.instance.getGroup(usingId);
            if (group == null) {
                return "";
            }
            return group.getNameColoredBukkit();
        }
        if (params.equalsIgnoreCase("current_dominion")) {
            DominionDTO dominion = CacheManager.instance.getDominion(bukkitPlayer.getLocation());
            if (dominion == null) {
                return "";
            }
            return dominion.getName();
        }
        if (params.startsWith("tp_loc_")) {
            String coordinate = params.substring(8, 9);
            String dominionName = params.substring(10);
            DominionDTO dominion = CacheManager.instance.getDominion(dominionName);
            if (dominion == null) {
                return null;
            }
            return switch (coordinate) {
                case "x" -> String.valueOf(dominion.getTpLocation().getBlockX());
                case "y" -> String.valueOf(dominion.getTpLocation().getBlockY());
                case "z" -> String.valueOf(dominion.getTpLocation().getBlockZ());
                default -> null;
            };
        }
        if (params.equalsIgnoreCase("is_member")) {
            DominionDTO dominion = CacheManager.instance.getDominion(bukkitPlayer.getLocation());
            if (dominion == null) {
                return null;
            }
            return dominion.getMembers().stream().anyMatch(member -> member.getPlayer().getUuid().equals(bukkitPlayer.getUniqueId())) ? "true" : "false";
        }
        if (params.startsWith("is_member_")) {
            String dominionName = params.substring(17);
            DominionDTO dominion = CacheManager.instance.getDominion(dominionName);
            if (dominion == null) {
                return null;
            }
            return dominion.getMembers().stream().anyMatch(member -> member.getPlayer().getUuid().equals(bukkitPlayer.getUniqueId())) ? "true" : "false";
        }
        if (params.equalsIgnoreCase("members")) {
            DominionDTO dominion = CacheManager.instance.getDominion(bukkitPlayer.getLocation());
            if (dominion == null) {
                return null;
            }
            return dominion.getMembers().stream().map(member -> member.getPlayer().getLastKnownName()).reduce((a, b) -> a + ", " + b).orElse("");
        }
        if (params.startsWith("members_")) {
            String dominionName = params.substring(9);
            DominionDTO dominion = CacheManager.instance.getDominion(dominionName);
            if (dominion == null) {
                return null;
            }
            return dominion.getMembers().stream().map(member -> member.getPlayer().getLastKnownName()).reduce((a, b) -> a + ", " + b).orElse("");
        }
        if (params.equalsIgnoreCase("member_count")) {
            DominionDTO dominion = CacheManager.instance.getDominion(bukkitPlayer.getLocation());
            if (dominion == null) {
                return null;
            }
            return String.valueOf(dominion.getMembers().size());
        }
        if (params.startsWith("member_count_")) {
            String dominionName = params.substring(14);
            DominionDTO dominion = CacheManager.instance.getDominion(dominionName);
            if (dominion == null) {
                return null;
            }
            return String.valueOf(dominion.getMembers().size());
        }
        if (params.equalsIgnoreCase("group")) {
            DominionDTO dominion = CacheManager.instance.getDominion(bukkitPlayer.getLocation());
            if (dominion == null) {
                return null;
            }
            return PlaceholderAPIHook.getGroupName(bukkitPlayer, dominion);
        }
        if (params.startsWith("group_")) {
            String dominionName = params.substring(6);
            DominionDTO dominion = CacheManager.instance.getDominion(dominionName);
            if (dominion == null) {
                return null;
            }
            return PlaceholderAPIHook.getGroupName(bukkitPlayer, dominion);
        }
        if (params.equalsIgnoreCase("groups")) {
            DominionDTO dominion = CacheManager.instance.getDominion(bukkitPlayer.getLocation());
            if (dominion == null) {
                return null;
            }
            return dominion.getGroups().stream().map(GroupDTO::getNameColoredBukkit).reduce((a, b) -> a + ", " + b).orElse("");
        }
        if (params.startsWith("groups_")) {
            String dominionName = params.substring(7);
            DominionDTO dominion = CacheManager.instance.getDominion(dominionName);
            if (dominion == null) {
                return null;
            }
            return dominion.getGroups().stream().map(GroupDTO::getNameColoredBukkit).reduce((a, b) -> a + ", " + b).orElse("");
        }
        if (params.equalsIgnoreCase("group_count")) {
            DominionDTO dominion = CacheManager.instance.getDominion(bukkitPlayer.getLocation());
            if (dominion == null) {
                return null;
            }
            return String.valueOf(dominion.getGroups().size());
        }
        if (params.startsWith("pri_flag_")) {
            String flagName = params.substring(10);
            PriFlag flag = Flags.getPreFlag(flagName);
            if (flag == null) {
                return null;
            }
            return String.valueOf(Others.checkPrivilegeFlagSilence(bukkitPlayer.getLocation(), flag, bukkitPlayer, null));
        }
        if (params.startsWith("env_flag_")) {
            String flagName = params.substring(9);
            EnvFlag envFlag = Flags.getEnvFlag(flagName);
            if (envFlag == null) {
                return null;
            }
            return String.valueOf(Others.checkEnvironmentFlag(bukkitPlayer.getLocation(), envFlag, null));
        }
        return null;
    }

    @Nullable
    private static String getGroupName(Player bukkitPlayer, DominionDTO dominion) {
        MemberDTO member = CacheManager.instance.getMember(dominion, bukkitPlayer);
        if (member == null || member.getGroupId() == -1) {
            return null;
        }
        GroupDTO group = CacheManager.instance.getGroup(member);
        if (group == null) {
            return null;
        }
        return group.getNameColoredBukkit();
    }

    @NotNull
    public String getIdentifier() {
        return "dominion";
    }

    @NotNull
    public String getAuthor() {
        return "zhangyuheng";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }
}

