/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.handler;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldLoadHandler
implements Listener {
    private static WorldLoadHandler instance;
    private final List<World> loadedWorlds = new ArrayList<World>();
    private final List<Consumer<World>> runners = new ArrayList<Consumer<World>>();

    public static WorldLoadHandler getInstance() {
        if (instance == null) {
            new WorldLoadHandler(Dominion.instance);
        }
        return instance;
    }

    public WorldLoadHandler(JavaPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        instance = this;
        Scheduler.runTaskLaterAsync(() -> {
            for (World world : plugin.getServer().getWorlds()) {
                if (this.loadedWorlds.contains(world)) continue;
                this.loadedWorlds.add(world);
                for (Consumer<World> runner : this.runners) {
                    try {
                        runner.accept(world);
                    }
                    catch (Exception e) {
                        XLogger.error(e);
                    }
                }
            }
        }, 1800L);
    }

    public void addRunner(Consumer<World> runner) {
        this.runners.add(runner);
    }

    @EventHandler
    public void onWorldLoaded(WorldLoadEvent event) {
        World world = event.getWorld();
        if (!this.loadedWorlds.contains(world)) {
            this.loadedWorlds.add(world);
        }
        for (Consumer<World> runner : this.runners) {
            try {
                runner.accept(world);
            }
            catch (Exception e) {
                XLogger.error(e);
            }
        }
    }
}

