/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.events.group;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.events.ResultEvent;
import cn.lunadeer.dominion.utils.ColorParser;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupCreateEvent
extends ResultEvent {
    private DominionDTO dominion;
    private String groupName;
    private final CompletableFuture<GroupDTO> future = new CompletableFuture();

    public GroupCreateEvent(@NotNull CommandSender operator, @NotNull DominionDTO dominion, @NotNull String groupName) {
        super(operator);
        this.dominion = dominion;
        this.groupName = groupName;
    }

    public void setDominion(@NotNull DominionDTO dominion) {
        this.dominion = dominion;
    }

    @NotNull
    public DominionDTO getDominion() {
        return this.dominion;
    }

    public void setGroupNameColored(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupNameColored() {
        return this.groupName;
    }

    public String getGroupNamePlain() {
        return ColorParser.getPlainText(this.groupName);
    }

    public CompletableFuture<GroupDTO> getFutureToComplete() {
        return this.future;
    }

    public CompletableFuture<Void> afterCreated(Consumer<GroupDTO> consumer) {
        return this.future.thenAccept((Consumer)consumer);
    }

    @Deprecated(since="4.6.0", forRemoval=true)
    public void setGroup(@NotNull GroupDTO group) {
    }

    @Deprecated(since="4.6.0", forRemoval=true)
    @Nullable
    public GroupDTO getGroup() {
        return null;
    }
}

