/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.events.dominion.modify;

import cn.lunadeer.dominion.api.dtos.CuboidDTO;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.events.dominion.modify.DominionModifyEvent;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class DominionReSizeEvent
extends DominionModifyEvent {
    private boolean skipEconomy = false;
    private final CuboidDTO oldCuboid;
    private final TYPE type;
    private DIRECTION direction;
    private int size;

    public DominionReSizeEvent(@NotNull CommandSender operator, @NotNull DominionDTO dominion, @NotNull TYPE type, @NotNull DIRECTION direction, int size) {
        super(operator, dominion);
        this.oldCuboid = dominion.getCuboid();
        this.type = type;
        this.direction = direction;
        this.size = size;
    }

    public void setSkipEconomy(boolean skipEconomy) {
        this.skipEconomy = skipEconomy;
    }

    public boolean isSkipEconomy() {
        return this.skipEconomy;
    }

    public CuboidDTO getOldCuboid() {
        return this.oldCuboid;
    }

    public TYPE getType() {
        return this.type;
    }

    public DIRECTION getDirection() {
        return this.direction;
    }

    public int getSize() {
        return this.size;
    }

    public void setDirection(DIRECTION direction) {
        this.direction = direction;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public CuboidDTO getNewCuboid() {
        CuboidDTO newCuboid = new CuboidDTO(this.getOldCuboid());
        int addSize = this.size * (this.type == TYPE.EXPAND ? 1 : -1);
        switch (this.direction) {
            case UP: {
                newCuboid.addUp(addSize);
                break;
            }
            case DOWN: {
                newCuboid.addDown(addSize);
                break;
            }
            case NORTH: {
                newCuboid.addNorth(addSize);
                break;
            }
            case SOUTH: {
                newCuboid.addSouth(addSize);
                break;
            }
            case EAST: {
                newCuboid.addEast(addSize);
                break;
            }
            case WEST: {
                newCuboid.addWest(addSize);
            }
        }
        return newCuboid;
    }

    public static enum TYPE {
        EXPAND,
        CONTRACT;

    }

    public static enum DIRECTION {
        NORTH,
        EAST,
        SOUTH,
        WEST,
        UP,
        DOWN;

    }
}

