/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.commands;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.CuboidDTO;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.events.dominion.modify.DominionReSizeEvent;
import cn.lunadeer.dominion.events.dominion.modify.DominionSetMessageEvent;
import cn.lunadeer.dominion.handler.DominionProviderHandler;
import cn.lunadeer.dominion.managers.TeleportManager;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.misc.DominionException;
import cn.lunadeer.dominion.providers.DominionProvider;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.Option;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DominionOperateCommand {
    public static SecondaryCommand resize = new SecondaryCommand("resize", List.of(new CommandArguments.RequiredDominionArgument(), new Option(Arrays.stream(DominionReSizeEvent.TYPE.values()).map(Enum::name).map(String::toLowerCase).toList()), new Argument("size", true), new Option(Arrays.stream(DominionReSizeEvent.DIRECTION.values()).map(Enum::name).map(String::toLowerCase).toList(), "")), Language.dominionOperateCommandText.resizeDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.resize(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2), this.getArgumentValue(3));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand easyExpand = new SecondaryCommand("expand", List.of(new Argument("size", true), new Option(Arrays.stream(DominionReSizeEvent.DIRECTION.values()).map(Enum::name).map(String::toLowerCase).toList(), "")), Language.dominionOperateCommandText.easyExpandDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.easyResize(sender, DominionReSizeEvent.TYPE.EXPAND.name(), this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand easyContract = new SecondaryCommand("contract", List.of(new Argument("size", true), new Option(Arrays.stream(DominionReSizeEvent.DIRECTION.values()).map(Enum::name).map(String::toLowerCase).toList(), "")), Language.dominionOperateCommandText.easyContractDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.easyResize(sender, DominionReSizeEvent.TYPE.CONTRACT.name(), this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand delete = new SecondaryCommand("delete", List.of(new CommandArguments.RequiredDominionArgument(), new Option(List.of("force"), "")), Language.dominionOperateCommandText.deleteDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.delete(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand setMessage = new SecondaryCommand("set_msg", (List)List.of(new CommandArguments.RequiredDominionArgument(), new Option(Arrays.stream(DominionSetMessageEvent.TYPE.values()).map(Enum::name).map(String::toLowerCase).toList()), new Argument("message", true)), Language.dominionOperateCommandText.setMessageDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.setMessage(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand setTeleport = new SecondaryCommand("set_tp", List.of(new CommandArguments.RequiredDominionArgument()), Language.dominionOperateCommandText.setTeleportDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.setTp(sender, this.getArgumentValue(0));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand rename = new SecondaryCommand("rename", (List)List.of(new CommandArguments.RequiredDominionArgument(), new Argument("newName", true)), Language.dominionOperateCommandText.renameDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.rename(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand setMapColor = new SecondaryCommand("set_map_color", (List)List.of(new CommandArguments.RequiredDominionArgument(), new Argument("color", true)), Language.dominionOperateCommandText.setMapColorDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.setMapColor(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand give = new SecondaryCommand("give", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredPlayerArgument(), new Option(List.of("force"), "")), Language.dominionOperateCommandText.giveDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                DominionDTO dominion = Converts.toDominionDTO(this.getArgumentValue(0));
                PlayerDTO player = Converts.toPlayerDTO(this.getArgumentValue(1));
                boolean force = this.getArgumentValue(2).equals("force");
                DominionProviderHandler.getInstance().transferDominion(sender, dominion, player, force);
            }
            catch (Exception e) {
                Notification.error(sender, e);
            }
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand tp = new SecondaryCommand("tp", List.of(new CommandArguments.RequiredDominionArgument()), Language.dominionOperateCommandText.tpDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                Player player = Converts.toPlayer(sender);
                DominionDTO dominion = Converts.toDominionDTO(this.getArgumentValue(0));
                TeleportManager.teleportToDominion(player, dominion);
            }
            catch (Exception e) {
                Notification.error(sender, e);
            }
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand switchUi = new SecondaryCommand("switch_ui", List.of(new Option(List.of(PlayerDTO.UI_TYPE.TUI.name(), PlayerDTO.UI_TYPE.CUI.name()), "")), Language.dominionOperateCommandText.switchUiDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                PlayerDTO.UI_TYPE uiType;
                Player player = Converts.toPlayer(sender);
                PlayerDTO playerDTO = CacheManager.instance.getPlayer(player.getUniqueId());
                if (playerDTO == null) {
                    throw new DominionException("Player data not found.", new Object[0]);
                }
                String uiTypeStr = this.getArgumentValue(0);
                if (uiTypeStr.isEmpty()) {
                    uiType = playerDTO.getUiPreference() == PlayerDTO.UI_TYPE.TUI ? PlayerDTO.UI_TYPE.CUI : PlayerDTO.UI_TYPE.TUI;
                } else {
                    if (!Arrays.stream(PlayerDTO.UI_TYPE.values()).map(Enum::name).toList().contains(uiTypeStr)) {
                        throw new DominionException("Invalid UI type: " + uiTypeStr + ". Valid types are: " + String.valueOf(Arrays.stream(PlayerDTO.UI_TYPE.values()).map(Enum::name).toList()), new Object[0]);
                    }
                    uiType = PlayerDTO.UI_TYPE.valueOf(uiTypeStr);
                }
                playerDTO.setUiPreference(uiType);
                MainMenu.show(sender, "1");
            }
            catch (Exception e) {
                Notification.error(sender, e);
            }
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand easyInfo = new SecondaryCommand("info", List.of(), TextUserInterface.sizeInfoTuiText.description){

        @Override
        public void executeHandler(CommandSender sender) {
            if (!(sender instanceof Player)) {
                Notification.error(sender, "This command can only be executed by a player.");
                return;
            }
            Player player = (Player)sender;
            Location location = player.getLocation();
            DominionDTO dominion = CacheManager.instance.getDominion(location);
            if (dominion == null) {
                Notification.error((CommandSender)player, Language.selectPointEventsHandlerText.noDominion, location.getBlockX(), location.getBlockY(), location.getBlockZ());
                return;
            }
            Notification.info((CommandSender)player, ">--------------------<");
            Notification.info((CommandSender)player, dominion.getName());
            PlayerDTO owner = CacheManager.instance.getPlayer(dominion.getOwner());
            if (owner == null) {
                Notification.info((CommandSender)player, ">--------------------<");
                return;
            }
            Notification.info((CommandSender)player, "");
            Notification.info((CommandSender)player, TextUserInterface.sizeInfoTuiText.ownerName, owner.getLastKnownName());
            CuboidDTO cuboid = dominion.getCuboid();
            Notification.info((CommandSender)player, TextUserInterface.sizeInfoTuiText.infoLWH, cuboid.xLength(), cuboid.yLength(), cuboid.zLength());
            Notification.info((CommandSender)player, TextUserInterface.sizeInfoTuiText.infoHeight, cuboid.y1(), cuboid.y2());
            Notification.info((CommandSender)player, ">--------------------<");
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void resize(CommandSender sender, String dominionName, String operation, String sizeStr, String faceStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            DominionReSizeEvent.TYPE type = Converts.toResizeType(operation);
            int size = Converts.toIntegrity(sizeStr);
            DominionReSizeEvent.DIRECTION dir = faceStr.isEmpty() ? Converts.toDirection(Converts.toPlayer(sender)) : Converts.toDirection(faceStr);
            DominionProviderHandler.getInstance().resizeDominion(sender, dominion, type, dir, size);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void easyResize(CommandSender sender, String operation, String sizeStr, String faceStr) {
        try {
            Player player = Converts.toPlayer(sender);
            Location location = player.getLocation();
            DominionDTO dominion = CacheManager.instance.getDominion(location);
            if (dominion == null) {
                throw new DominionException(Language.selectPointEventsHandlerText.noDominion, location.getBlockX(), location.getBlockY(), location.getBlockZ());
            }
            DominionReSizeEvent.TYPE type = Converts.toResizeType(operation);
            int size = Converts.toIntegrity(sizeStr);
            DominionReSizeEvent.DIRECTION dir = faceStr.isEmpty() ? Converts.toDirection(player) : Converts.toDirection(faceStr);
            DominionProviderHandler.getInstance().resizeDominion(sender, dominion, type, dir, size);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void setMessage(CommandSender sender, String dominionName, String typeStr, String msg) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            DominionSetMessageEvent.TYPE type = Converts.toMessageType(typeStr);
            DominionProvider.getInstance().setDominionMessage(sender, dominion, type, msg);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void delete(CommandSender sender, String dominionName, String forceStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            boolean force = forceStr.equals("force");
            DominionProviderHandler.getInstance().deleteDominion(sender, dominion, false, force);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void rename(CommandSender sender, String dominionName, String newName) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            DominionProviderHandler.getInstance().renameDominion(sender, dominion, newName);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void setMapColor(CommandSender sender, String dominionName, String colorStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            Color color = Converts.toColor(colorStr);
            DominionProvider.getInstance().setDominionMapColor(sender, dominion, color);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void setTp(CommandSender sender, String dominionName) {
        try {
            Player player = Converts.toPlayer(sender);
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            DominionProvider.getInstance().setDominionTpLocation(sender, dominion, player.getLocation());
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static class DominionOperateCommandText
    extends ConfigurationPart {
        public String resizeDescription = "Resize a dominion with a specific size and direction.";
        public String easyExpandDescription = "Expand the dominion size easily based on the player's current location.";
        public String easyContractDescription = "Contract the dominion size easily based on the player's current location.";
        public String deleteDescription = "Delete a dominion. Use 'force' to confirm deletion.";
        public String setMessageDescription = "Set a message for a dominion, either for entering or leaving.";
        public String setTeleportDescription = "Set the teleport location for a dominion.";
        public String renameDescription = "Rename a dominion.";
        public String setMapColorDescription = "Set the map color for a dominion.";
        public String giveDescription = "Give a dominion to a player.";
        public String tpDescription = "Teleport to a dominion.";
        public String switchUiDescription = "Switch the UI type for the dominion commands.";
    }
}

