/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.api.dtos;

import java.util.Vector;
import org.bukkit.Location;
import org.bukkit.World;

public class CuboidDTO {
    public static CuboidDTO ZERO = new CuboidDTO(0, 0, 0, 0, 0, 0);
    private int[] pos1 = new int[3];
    private int[] pos2 = new int[3];

    public CuboidDTO(int[] pos1, int[] pos2) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.sortPos();
    }

    public CuboidDTO(CuboidDTO cuboid) {
        this.pos1 = (int[])cuboid.getPos1().clone();
        this.pos2 = (int[])cuboid.getPos2().clone();
    }

    public CuboidDTO(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.pos1[0] = x1;
        this.pos1[1] = y1;
        this.pos1[2] = z1;
        this.pos2[0] = x2;
        this.pos2[1] = y2;
        this.pos2[2] = z2;
        this.sortPos();
    }

    public CuboidDTO(Vector<Integer> pos1, Vector<Integer> pos2) {
        this.pos1[0] = pos1.get(0);
        this.pos1[1] = pos1.get(1);
        this.pos1[2] = pos1.get(2);
        this.pos2[0] = pos2.get(0);
        this.pos2[1] = pos2.get(1);
        this.pos2[2] = pos2.get(2);
        this.sortPos();
    }

    public CuboidDTO(Location loc1, Location loc2) {
        this.pos1[0] = loc1.getBlockX();
        this.pos1[1] = loc1.getBlockY();
        this.pos1[2] = loc1.getBlockZ();
        this.pos2[0] = loc2.getBlockX();
        this.pos2[1] = loc2.getBlockY();
        this.pos2[2] = loc2.getBlockZ();
        this.sortPos();
    }

    private void sortPos() {
        int[] temp = new int[3];
        for (int i = 0; i < 3; ++i) {
            if (this.pos1[i] <= this.pos2[i]) continue;
            temp[i] = this.pos1[i];
            this.pos1[i] = this.pos2[i];
            this.pos2[i] = temp[i];
        }
    }

    public int[] getPos1() {
        return (int[])this.pos1.clone();
    }

    public void setPos1(int[] pos1) {
        this.pos1 = (int[])pos1.clone();
    }

    public int[] getPos2() {
        return (int[])this.pos2.clone();
    }

    public void setPos2(int[] pos2) {
        this.pos2 = (int[])pos2.clone();
    }

    public Location getLoc1(World world) {
        return new Location(world, (double)this.pos1[0], (double)this.pos1[1], (double)this.pos1[2]);
    }

    public Location getLoc2(World world) {
        return new Location(world, (double)this.pos2[0], (double)this.pos2[1], (double)this.pos2[2]);
    }

    public int x1() {
        return this.pos1[0];
    }

    public int y1() {
        return this.pos1[1];
    }

    public int z1() {
        return this.pos1[2];
    }

    public int x2() {
        return this.pos2[0];
    }

    public int y2() {
        return this.pos2[1];
    }

    public int z2() {
        return this.pos2[2];
    }

    public long xLength() {
        return this.pos2[0] - this.pos1[0];
    }

    public long yLength() {
        return this.pos2[1] - this.pos1[1];
    }

    public long zLength() {
        return this.pos2[2] - this.pos1[2];
    }

    public long getSquare() {
        return this.xLength() * this.zLength();
    }

    public long getVolume() {
        return this.xLength() * this.yLength() * this.zLength();
    }

    public boolean intersectWith(CuboidDTO cuboid) {
        return this.x1() < cuboid.x2() && this.x2() > cuboid.x1() && this.y1() < cuboid.y2() && this.y2() > cuboid.y1() && this.z1() < cuboid.z2() && this.z2() > cuboid.z1();
    }

    public boolean contain(CuboidDTO cuboid) {
        return this.contain(cuboid, false);
    }

    public boolean contain(CuboidDTO cuboid, boolean ignoreY) {
        if (ignoreY) {
            return this.x1() <= cuboid.x1() && this.x2() >= cuboid.x2() && this.z1() <= cuboid.z1() && this.z2() >= cuboid.z2();
        }
        return this.x1() <= cuboid.x1() && this.x2() >= cuboid.x2() && this.y1() <= cuboid.y1() && this.y2() >= cuboid.y2() && this.z1() <= cuboid.z1() && this.z2() >= cuboid.z2();
    }

    public boolean contain(int x, int y, int z) {
        return this.x1() <= x && this.x2() >= x && this.y1() <= y && this.y2() >= y && this.z1() <= z && this.z2() >= z;
    }

    public boolean containedBy(CuboidDTO cuboid) {
        return cuboid.contain(this);
    }

    public long minusSquareWith(CuboidDTO cuboid) {
        return this.getSquare() - cuboid.getSquare();
    }

    public long minusVolumeWith(CuboidDTO cuboid) {
        return this.getVolume() - cuboid.getVolume();
    }

    public void addUp(int size) {
        this.pos2[1] = this.pos2[1] + size < this.pos1[1] ? this.pos1[1] + 1 : this.pos2[1] + size;
    }

    public void addDown(int size) {
        this.pos1[1] = this.pos1[1] - size > this.pos2[1] ? this.pos2[1] - 1 : this.pos1[1] - size;
    }

    public void addNorth(int size) {
        this.pos1[2] = this.pos1[2] - size > this.pos2[2] ? this.pos2[2] - 1 : this.pos1[2] - size;
    }

    public void addSouth(int size) {
        this.pos2[2] = this.pos2[2] + size < this.pos1[2] ? this.pos1[2] + 1 : this.pos2[2] + size;
    }

    public void addEast(int size) {
        this.pos2[0] = this.pos2[0] + size < this.pos1[0] ? this.pos1[0] + 1 : this.pos2[0] + size;
    }

    public void addWest(int size) {
        this.pos1[0] = this.pos1[0] - size > this.pos2[0] ? this.pos2[0] - 1 : this.pos1[0] - size;
    }
}

