/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.v1_20_1.events.environment.Move;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.events.SpigotOnly;
import cn.lunadeer.dominion.misc.Others;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.event.Listener;

@SpigotOnly
public class SpigotAnimalMonsterMove
implements Listener {
    private static final ConcurrentHashMap<UUID, Location> entityMap = new ConcurrentHashMap();

    public SpigotAnimalMonsterMove() {
        Scheduler.runTaskRepeat(() -> Dominion.instance.getServer().getWorlds().forEach(world -> world.getEntities().forEach(entity -> {
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            if (!entityMap.containsKey(entity.getUniqueId())) {
                entityMap.put(entity.getUniqueId(), entity.getLocation());
            } else {
                Location lastLoc = entityMap.get(entity.getUniqueId());
                Location currentLoc = entity.getLocation();
                DominionDTO dom = CacheManager.instance.getDominion(currentLoc);
                if (!Others.checkEnvironmentFlag(dom, Flags.ANIMAL_MOVE, null) && entity instanceof Animals) {
                    entity.teleport(lastLoc);
                } else if (!Others.checkEnvironmentFlag(dom, Flags.MONSTER_MOVE, null) && entity instanceof Monster) {
                    entity.teleport(lastLoc);
                } else {
                    entityMap.put(entity.getUniqueId(), currentLoc);
                }
            }
        })), 20L, 30L);
        Scheduler.runTaskRepeat(() -> entityMap.forEach((uuid, loc) -> {
            Entity e = Dominion.instance.getServer().getEntity(uuid);
            if (e == null || e.isDead()) {
                entityMap.remove(uuid);
            }
        }), 20L, 6000L);
    }
}

