/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.databse.syntax;

import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.databse.DatabaseManager;
import cn.lunadeer.dominion.utils.databse.DatabaseType;
import cn.lunadeer.dominion.utils.databse.syntax.Syntax;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;

public abstract class Delete
implements Syntax {
    protected String tableName;
    protected String where;
    protected Object[] whereArgs;

    public static Delete delete() {
        return switch (DatabaseManager.instance.getType()) {
            case DatabaseType.PGSQL -> new pgsql_impl();
            case DatabaseType.SQLITE -> new sqlite_impl();
            case DatabaseType.MYSQL -> new mysql_impl();
            default -> throw new UnsupportedOperationException("Database type: " + String.valueOf((Object)DatabaseManager.instance.getType()) + " not supported with DELETE");
        };
    }

    private Delete() {
    }

    public Delete from(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Delete where(String conditions, Object ... args) {
        this.where = conditions;
        this.whereArgs = args;
        return this;
    }

    public int execute() throws SQLException {
        int n;
        block10: {
            Connection conn = DatabaseManager.instance.getConnection();
            try {
                String sql = this.getSql();
                PreparedStatement preparedStatement = conn.prepareStatement(sql);
                int index = 1;
                if (this.whereArgs != null) {
                    for (Object arg : this.whereArgs) {
                        preparedStatement.setObject(index++, arg);
                    }
                }
                n = preparedStatement.executeUpdate();
                if (conn == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    XLogger.error("SQL: " + this.getSql());
                    XLogger.error("WHERE Param: " + Arrays.toString(this.whereArgs));
                    XLogger.error(e);
                    throw new SQLException("Error executing delete statement: " + e.getMessage(), e);
                }
            }
            conn.close();
        }
        return n;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder("DELETE FROM " + this.tableName);
        if (this.where != null) {
            sql.append(" WHERE ").append(this.where);
        }
        return sql.toString();
    }

    private static class pgsql_impl
    extends Delete {
        private pgsql_impl() {
        }

        @Override
        public String getSql() {
            return super.getSql();
        }
    }

    private static class sqlite_impl
    extends Delete {
        private sqlite_impl() {
        }

        @Override
        public String getSql() {
            return super.getSql();
        }
    }

    private static class mysql_impl
    extends Delete {
        private mysql_impl() {
        }

        @Override
        public String getSql() {
            return super.getSql();
        }
    }
}

