/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import cn.lunadeer.dominion.utils.XLogger;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class XVersionManager {
    public static ImplementationVersion VERSION;

    public static ImplementationVersion GetVersion(JavaPlugin plugin) {
        String version = plugin.getServer().getBukkitVersion();
        XLogger.debug("API version: {0}", version);
        if (version.contains("1.21")) {
            return ImplementationVersion.v1_21;
        }
        if (version.contains("1.20.1") || version.contains("1.20.4") || version.contains("1.20.6")) {
            return ImplementationVersion.v1_20_1;
        }
        XLogger.error("Unsupported API version: {0}", version);
        plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
        return null;
    }

    public static enum ImplementationVersion {
        v1_21,
        v1_20_1;

        private final int[] value;

        private ImplementationVersion() {
            String[] parts = this.name().replace("v", "").split("_");
            this.value = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                this.value[i] = Integer.parseInt(parts[i]);
            }
        }

        public int compareWith(ImplementationVersion other) {
            for (int i = 0; i < Math.min(this.value.length, other.value.length); ++i) {
                if (this.value[i] == other.value[i]) continue;
                return this.value[i] - other.value[i];
            }
            return this.value.length - other.value.length;
        }
    }
}

