/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.ChatColor;

public class ColorParser {
    public static TextComponent getComponentType(String text) {
        text = ColorParser.parseGradient(text);
        String[] parts = text.split("&#");
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        for (String part : parts) {
            String content;
            if (part.isEmpty()) continue;
            TextColor color = TextColor.fromHexString((String)"#ffffff");
            if (part.length() >= 6 && part.substring(0, 6).matches("^[0-9a-fA-F]{6}$")) {
                String color_str = part.substring(0, 6);
                color = TextColor.fromHexString((String)("#" + color_str));
                content = part.substring(6);
            } else {
                content = part;
            }
            components.add(Component.text((String)content, (TextColor)color));
        }
        TextComponent.Builder title_component = Component.text();
        for (TextComponent component : components) {
            title_component.append((Component)component);
        }
        return (TextComponent)title_component.build();
    }

    public static String getBukkitType(String text) {
        text = ColorParser.parseGradient(text);
        Object title = "&f" + text + "&f";
        title = ((String)title).replaceAll("&#", "#");
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher matcher = pattern.matcher((CharSequence)title);
        while (matcher.find()) {
            String hexCode = matcher.group();
            StringBuilder builder = new StringBuilder("&x");
            for (char c : hexCode.substring(1).toCharArray()) {
                builder.append('&').append(c);
            }
            title = ((String)title).replace(hexCode, builder.toString());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)title);
    }

    public static String getPlainText(String text) {
        text = ColorParser.parseGradient(text);
        String[] parts = text.split("&#");
        StringBuilder res = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            String content = part.length() >= 6 && part.substring(0, 6).matches("^[0-9a-fA-F]{6}$") ? part.substring(6) : part;
            res.append(content);
        }
        return res.toString();
    }

    private static String parseGradient(String text) {
        if (!((String)text).contains("<gradient:")) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        int startIndex = 0;
        while (startIndex < ((String)text).length()) {
            int openTagIndex = ((String)text).indexOf("<gradient:", startIndex);
            if (openTagIndex == -1) {
                result.append(((String)text).substring(startIndex));
                break;
            }
            result.append((CharSequence)text, startIndex, openTagIndex);
            int closeTagIndex = ((String)text).indexOf("</gradient>", openTagIndex);
            if (closeTagIndex == -1) {
                closeTagIndex = ((String)text).length();
                text = (String)text + "</gradient>";
            }
            String gradientPart = ((String)text).substring(openTagIndex + 10, ((String)text).indexOf(">", openTagIndex));
            String[] colors = gradientPart.split(":");
            String content = ((String)text).substring(((String)text).indexOf(">", openTagIndex) + 1, closeTagIndex);
            result.append(ColorParser.applyGradient(content, colors));
            startIndex = closeTagIndex + "</gradient>".length();
        }
        return result.toString();
    }

    private static String applyGradient(String content, String[] colors) {
        StringBuilder gradientText = new StringBuilder();
        int length = content.length();
        for (int i = 0; i < length; ++i) {
            float ratio = (float)i / (float)(length - 1);
            Color color = ColorParser.interpolateColor(colors, ratio);
            String hexColor = String.format("#%06x", color.getRGB() & 0xFFFFFF);
            gradientText.append("&#").append(hexColor.substring(1)).append(content.charAt(i));
        }
        return gradientText.toString();
    }

    private static Color interpolateColor(String[] colors, float ratio) {
        int segment = (int)(ratio * (float)(colors.length - 1));
        if (segment >= colors.length - 1) {
            return Color.decode(colors[colors.length - 1]);
        }
        float segmentRatio = ratio * (float)(colors.length - 1) - (float)segment;
        Color color1 = Color.decode(colors[segment]);
        Color color2 = Color.decode(colors[segment + 1]);
        int red = (int)((float)color1.getRed() * (1.0f - segmentRatio) + (float)color2.getRed() * segmentRatio);
        int green = (int)((float)color1.getGreen() * (1.0f - segmentRatio) + (float)color2.getGreen() * segmentRatio);
        int blue = (int)((float)color1.getBlue() * (1.0f - segmentRatio) + (float)color2.getBlue() * segmentRatio);
        return new Color(red, green, blue);
    }
}

