/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion.manage.member;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.commands.MemberCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.MemberDOO;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionList;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.member.MemberSetting;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.member.SelectPlayer;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.Button;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;

public class MemberList {
    public static SecondaryCommand list = new SecondaryCommand("member_list", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            MemberList.show(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    private static final TextComponent adminTag = (TextComponent)Component.text((String)"[A]", (Style)Style.style((TextColor)TextColor.color((int)97, (int)97, (int)210))).hoverEvent((HoverEventSource)Component.text((String)Language.memberListTuiText.tagAdmin));
    private static final TextComponent normalTag = (TextComponent)Component.text((String)"[N]", (Style)Style.style((TextColor)TextColor.color((int)255, (int)255, (int)255))).hoverEvent((HoverEventSource)Component.text((String)Language.memberListTuiText.tagNormal));
    private static final TextComponent banTag = (TextComponent)Component.text((String)"[B]", (Style)Style.style((TextColor)TextColor.color((int)255, (int)67, (int)0))).hoverEvent((HoverEventSource)Component.text((String)Language.memberListTuiText.tagBan));
    private static final TextComponent groupTag = (TextComponent)Component.text((String)"[G]", (Style)Style.style((TextColor)TextColor.color((int)0, (int)185, (int)153))).hoverEvent((HoverEventSource)Component.text((String)Language.memberListTuiText.tagGroup));

    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(Language.memberListTuiText.button){

            @Override
            public void function(String pageStr) {
                MemberList.show(sender, dominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(final CommandSender sender, final String dominionName, final String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            Asserts.assertDominionAdmin(sender, dominion);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, MemberList.button(sender, dominionName));
            view.title(Misc.formatString(Language.memberListTuiText.title, dominion.getName()));
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, dominionName).build()).append(Language.memberListTuiText.button));
            view.add(Line.create().append(SelectPlayer.button(sender, dominionName).build()));
            ArrayList<MemberDOO> members = new ArrayList<MemberDOO>(MemberDOO.selectByDominionId(dominion.getId()));
            for (MemberDTO memberDTO : members) {
                final PlayerDTO p_player = memberDTO.getPlayer();
                GroupDTO group = CacheManager.instance.getGroup(memberDTO.getGroupId());
                Line line = Line.create();
                if (group != null) {
                    line.append(groupTag);
                } else if (memberDTO.getFlagValue(Flags.ADMIN).booleanValue()) {
                    line.append(adminTag);
                } else if (!memberDTO.getFlagValue(Flags.MOVE).booleanValue()) {
                    line.append(banTag);
                } else {
                    line.append(normalTag);
                }
                Button prev = MemberSetting.button(sender, dominionName, p_player.getLastKnownName()).green();
                Button remove = new FunctionalButton(Language.memberListTuiText.remove){

                    @Override
                    public void function() {
                        MemberCommand.removeMember(sender, dominionName, p_player.getLastKnownName(), pageStr);
                    }
                }.setHoverText(Language.memberListTuiText.removeDescription).red();
                boolean disable = false;
                try {
                    Asserts.assertDominionOwner(sender, dominion);
                }
                catch (Exception e) {
                    disable = memberDTO.getFlagValue(Flags.ADMIN);
                }
                if (disable) {
                    prev.setDisabled(Language.memberListTuiText.ownerOnly);
                    remove.setDisabled(Language.memberListTuiText.ownerOnly);
                }
                if (group != null) {
                    prev.setDisabled(Misc.formatString(Language.memberListTuiText.groupOnly, group.getNamePlain()));
                }
                line.append(remove.build());
                line.append(prev.build());
                line.append(p_player.getLastKnownName());
                view.add(line);
            }
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class MemberListTuiText
    extends ConfigurationPart {
        public String title = "{0} Member List";
        public String description = "List of members of this dominion.";
        public String button = "MEMBERS";
        public String remove = "REMOVE";
        public String removeDescription = "Remove this member from this dominion.";
        public String ownerOnly = "Only owner can manage admin member.";
        public String groupOnly = "This member belong to group {0} so you can't manage it separately.";
        public String tagAdmin = "Admin can manage members and groups of this dominion.";
        public String tagNormal = "Normal members.";
        public String tagBan = "Who don't have MOVE privilege.";
        public String tagGroup = "This player belong to a group, you can't manage it separately.";
    }
}

