/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion.manage.group;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.commands.GroupCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.GroupDOO;
import cn.lunadeer.dominion.doos.MemberDOO;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.inputters.CreateGroupInputter;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionList;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.group.GroupSetting;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.group.SelectMember;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.Button;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;

public class GroupList {
    public static SecondaryCommand list = new SecondaryCommand("group_list", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            GroupList.show(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(Language.groupListTuiText.button){

            @Override
            public void function(String page) {
                GroupList.show(sender, dominionName, page);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(final CommandSender sender, final String dominionName, final String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            Asserts.assertDominionAdmin(sender, dominion);
            int page = Converts.toIntegrity(pageStr);
            List<GroupDOO> groups = GroupDOO.selectByDominionId(dominion.getId());
            ListView view = ListView.create(10, GroupList.button(sender, dominionName));
            view.title(Misc.formatString(Language.groupListTuiText.title, dominion.getName()));
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, dominionName).build()).append(Language.groupListTuiText.button));
            view.add(new Line().append(CreateGroupInputter.createOn(sender, dominionName).needPermission(Dominion.defaultPermission).build()));
            ArrayList<MemberDOO> members = new ArrayList<MemberDOO>(MemberDOO.selectByDominionId(dominion.getId()));
            for (final GroupDTO groupDTO : groups) {
                Line line = new Line();
                Button deleteGroup = new FunctionalButton(Language.groupListTuiText.deleteButton){

                    @Override
                    public void function() {
                        GroupCommand.deleteGroup(sender, dominionName, groupDTO.getNamePlain(), pageStr);
                    }
                }.needPermission(Dominion.defaultPermission).red().setHoverText(Language.groupListTuiText.deleteDescription);
                ListViewButton setting = GroupSetting.button(sender, dominionName, groupDTO.getNamePlain());
                ListViewButton addMember = SelectMember.button(sender, dominionName, groupDTO.getNamePlain(), pageStr);
                line.append(deleteGroup.build()).append(setting.build()).append(groupDTO.getNameColoredComponent()).append(addMember.build());
                view.add(line);
                for (MemberDTO memberDTO : members) {
                    if (!memberDTO.getGroupId().equals(groupDTO.getId())) continue;
                    final PlayerDTO p = Converts.toPlayerDTO(memberDTO.getPlayerUUID());
                    Button remove = new FunctionalButton("-"){

                        @Override
                        public void function() {
                            GroupCommand.removeMember(sender, dominionName, groupDTO.getNamePlain(), p.getLastKnownName(), pageStr);
                        }
                    }.needPermission(Dominion.defaultPermission).red().setHoverText(Language.groupListTuiText.removeMemberDescription);
                    Line playerLine = new Line().setDivider("");
                    playerLine.append(Component.text((String)"        "));
                    playerLine.append(remove.build()).append(" |  " + p.getLastKnownName());
                    view.add(playerLine);
                }
                view.add(new Line().append(""));
            }
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class GroupListTuiText
    extends ConfigurationPart {
        public String title = "{0} Group List";
        public String description = "List of groups of this dominion.";
        public String button = "GROUPS";
        public String deleteButton = "DELETE";
        public String deleteDescription = "Delete this group, all members will be move out of this group.";
        public String removeMemberDescription = "Remove {0} from group {1} to default group.";
    }
}

