/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion.copy;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionList;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.tuis.dominion.copy.EnvCopy;
import cn.lunadeer.dominion.uis.tuis.dominion.copy.GroupCopy;
import cn.lunadeer.dominion.uis.tuis.dominion.copy.GuestCopy;
import cn.lunadeer.dominion.uis.tuis.dominion.copy.MemberCopy;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import org.bukkit.command.CommandSender;

public class CopyMenu {
    public static ListViewButton button(final CommandSender sender, final String toDominionName) {
        return (ListViewButton)new ListViewButton(Language.copyMenuTuiText.button){

            @Override
            public void function(String pageStr) {
                CopyMenu.show(sender, toDominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(CommandSender sender, String toDominionName, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(toDominionName);
            Asserts.assertDominionAdmin(sender, dominion);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, CopyMenu.button(sender, toDominionName));
            view.title(Misc.formatString(Language.copyMenuTuiText.title, new Object[0]));
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, toDominionName).build()).append(Language.copyMenuTuiText.button));
            view.add(Line.create().append(EnvCopy.button(sender, toDominionName).build()).append(Language.envCopyTuiText.description));
            view.add(Line.create().append(GuestCopy.button(sender, toDominionName).build()).append(Language.guestCopyTuiText.description));
            view.add(Line.create().append(MemberCopy.button(sender, toDominionName).build()).append(Language.memberCopyTuiText.description));
            view.add(Line.create().append(GroupCopy.button(sender, toDominionName).build()).append(Language.groupCopyTuiText.description));
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class CopyMenuTuiText
    extends ConfigurationPart {
        public String button = "COPY";
        public String description = "Copy Privilege Settings From Other Dominion.";
        public String title = "Select Copy Type";
    }
}

