/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.commands;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.events.dominion.DominionDeleteEvent;
import cn.lunadeer.dominion.events.dominion.modify.DominionReSizeEvent;
import cn.lunadeer.dominion.events.dominion.modify.DominionRenameEvent;
import cn.lunadeer.dominion.events.dominion.modify.DominionSetMapColorEvent;
import cn.lunadeer.dominion.events.dominion.modify.DominionSetMessageEvent;
import cn.lunadeer.dominion.events.dominion.modify.DominionSetTpLocationEvent;
import cn.lunadeer.dominion.events.dominion.modify.DominionTransferEvent;
import cn.lunadeer.dominion.managers.TeleportManager;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.Option;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DominionOperateCommand {
    public static SecondaryCommand resize = new SecondaryCommand("resize", List.of(new CommandArguments.RequiredDominionArgument(), new Option(Arrays.stream(DominionReSizeEvent.TYPE.values()).map(Enum::name).map(String::toLowerCase).toList()), new Argument("size", true), new Option(Arrays.stream(DominionReSizeEvent.DIRECTION.values()).map(Enum::name).map(String::toLowerCase).toList(), ""))){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.resize(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2), this.getArgumentValue(3));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand delete = new SecondaryCommand("delete", List.of(new CommandArguments.RequiredDominionArgument(), new Option(List.of("force"), ""))){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.delete(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand setMessage = new SecondaryCommand("set_msg", (List)List.of(new CommandArguments.RequiredDominionArgument(), new Option(Arrays.stream(DominionSetMessageEvent.TYPE.values()).map(Enum::name).map(String::toLowerCase).toList()), new Argument("message", true))){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.setMessage(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand setTeleport = new SecondaryCommand("set_tp", List.of(new CommandArguments.RequiredDominionArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.setTp(sender, this.getArgumentValue(0));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand rename = new SecondaryCommand("rename", (List)List.of(new CommandArguments.RequiredDominionArgument(), new Argument("newName", true))){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.rename(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand setMapColor = new SecondaryCommand("set_map_color", (List)List.of(new CommandArguments.RequiredDominionArgument(), new Argument("color", true))){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionOperateCommand.setMapColor(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand give = new SecondaryCommand("give", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredPlayerArgument(), new Option(List.of("force"), ""))){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                DominionDTO dominion = Converts.toDominionDTO(this.getArgumentValue(0));
                PlayerDTO player = Converts.toPlayerDTO(this.getArgumentValue(1));
                boolean force = this.getArgumentValue(2).equals("force");
                DominionTransferEvent event = new DominionTransferEvent(sender, dominion, player);
                event.setForce(force);
                event.call();
            }
            catch (Exception e) {
                Notification.error(sender, e);
            }
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand tp = new SecondaryCommand("tp", List.of(new CommandArguments.RequiredDominionArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                Player player = Converts.toPlayer(sender);
                DominionDTO dominion = Converts.toDominionDTO(this.getArgumentValue(0));
                TeleportManager.teleportToDominion(player, dominion);
            }
            catch (Exception e) {
                Notification.error(sender, e);
            }
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void resize(CommandSender sender, String dominionName, String operation, String sizeStr, String faceStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            DominionReSizeEvent.TYPE type = Converts.toResizeType(operation);
            int size = Converts.toIntegrity(sizeStr);
            DominionReSizeEvent.DIRECTION dir = faceStr.isEmpty() ? Converts.toDirection(Converts.toPlayer(sender)) : Converts.toDirection(faceStr);
            new DominionReSizeEvent(sender, dominion, type, dir, size).call();
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void setMessage(CommandSender sender, String dominionName, String typeStr, String msg) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            DominionSetMessageEvent.TYPE type = Converts.toMessageType(typeStr);
            new DominionSetMessageEvent(sender, dominion, type, msg).call();
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void delete(CommandSender sender, String dominionName, String forceStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            boolean force = forceStr.equals("force");
            DominionDeleteEvent even = new DominionDeleteEvent(sender, dominion);
            even.setForce(force);
            even.call();
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void rename(CommandSender sender, String dominionName, String newName) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            new DominionRenameEvent(sender, dominion, newName).call();
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void setMapColor(CommandSender sender, String dominionName, String colorStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            Color color = Converts.toColor(colorStr);
            new DominionSetMapColorEvent(sender, dominion, color).call();
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void setTp(CommandSender sender, String dominionName) {
        try {
            Player player = Converts.toPlayer(sender);
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            new DominionSetTpLocationEvent(sender, dominion, player.getLocation()).call();
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }
}

