/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache.server;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.cache.server.Cache;
import cn.lunadeer.dominion.doos.GroupDOO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupCache
extends Cache {
    private final Integer serverId;
    private ConcurrentHashMap<Integer, GroupDTO> idGroups;
    private ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> dominionGroupsMap;

    public GroupCache(Integer serverId) {
        this.serverId = serverId;
    }

    @Nullable
    public GroupDTO getGroup(Integer id) {
        return this.idGroups.get(id);
    }

    @NotNull
    public List<GroupDTO> getDominionGroups(DominionDTO dominion) {
        if (dominion == null) {
            return new ArrayList<GroupDTO>();
        }
        return this.getDominionGroups(dominion.getId());
    }

    @NotNull
    public List<GroupDTO> getDominionGroups(Integer dominionId) {
        if (!this.dominionGroupsMap.containsKey(dominionId)) {
            return List.of();
        }
        ArrayList<GroupDTO> groups = new ArrayList<GroupDTO>();
        this.dominionGroupsMap.get(dominionId).forEach(groupId -> groups.add(this.idGroups.get(groupId)));
        return groups;
    }

    @Override
    void loadExecution() throws Exception {
        this.idGroups = new ConcurrentHashMap();
        this.dominionGroupsMap = new ConcurrentHashMap();
        List<GroupDOO> allGroups = GroupDOO.select();
        for (GroupDOO group : allGroups) {
            DominionDTO dominion = CacheManager.instance.getDominion(group.getDomID());
            if (dominion == null || !Objects.equals(dominion.getServerId(), this.serverId)) continue;
            this.idGroups.put(group.getId(), group);
            this.dominionGroupsMap.computeIfAbsent(dominion.getId(), k -> new CopyOnWriteArrayList()).add(group.getId());
        }
    }

    @Override
    void loadExecution(Integer idToLoad) throws Exception {
        GroupDOO group = GroupDOO.select(idToLoad);
        if (group == null) {
            return;
        }
        GroupDTO old = this.idGroups.put(group.getId(), group);
        if (old != null) {
            this.dominionGroupsMap.get(old.getDomID()).remove(old.getId());
        }
        this.dominionGroupsMap.computeIfAbsent(group.getDomID(), k -> new CopyOnWriteArrayList()).add(group.getId());
    }

    @Override
    void deleteExecution(Integer idToDelete) throws Exception {
        GroupDTO group = this.idGroups.remove(idToDelete);
        if (group == null) {
            return;
        }
        this.dominionGroupsMap.get(group.getDomID()).remove(group.getId());
    }

    public Integer count() {
        return this.idGroups.size();
    }
}

