/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.util.text;

import io.github.miniplaceholders.api.MiniPlaceholders;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Color;

public class TextUtil {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static boolean miniplaceholders = false;

    private TextUtil() {
        throw new UnsupportedOperationException();
    }

    public static Component parseWithPlaceholders(String message, TagResolver resolver) {
        if (miniplaceholders) {
            return MINI_MESSAGE.deserialize(message, new TagResolver[]{resolver, MiniPlaceholders.globalPlaceholders()});
        }
        return MINI_MESSAGE.deserialize(message, resolver);
    }

    public static Component parse(String message) {
        return MINI_MESSAGE.deserialize((Object)message);
    }

    public static Component parse(String message, TagResolver resolver) {
        return MINI_MESSAGE.deserialize(message, resolver);
    }

    public static Component parse(String message, Pointered target, TagResolver ... resolver) {
        return MINI_MESSAGE.deserialize(message, target, resolver);
    }

    public static String raw(Component message) {
        return ((String)MINI_MESSAGE.serialize(message)).replaceAll("\\\\<", "<");
    }

    public static Component replace(Component message, String pattern, Component replacement) {
        return TextUtil.parse(TextUtil.raw(message), (TagResolver)Placeholder.component((String)pattern, (ComponentLike)replacement));
    }

    public static String joinString(int index, String[] args) {
        StringBuilder builder = new StringBuilder();
        for (int i = index; i < args.length; ++i) {
            builder.append(args[i]).append(" ");
        }
        return builder.toString();
    }

    public static Color getColor(String s) {
        return switch (s.toUpperCase()) {
            case "AQUA" -> Color.AQUA;
            case "BLACK" -> Color.BLACK;
            case "BLUE" -> Color.BLUE;
            case "FUCHSIA" -> Color.FUCHSIA;
            case "GRAY" -> Color.GRAY;
            case "GREEN" -> Color.GREEN;
            case "LIME" -> Color.LIME;
            case "MAROON" -> Color.MAROON;
            case "NAVY" -> Color.NAVY;
            case "OLIVE" -> Color.OLIVE;
            case "ORANGE" -> Color.ORANGE;
            case "PURPLE" -> Color.PURPLE;
            case "RED" -> Color.RED;
            case "SILVER" -> Color.SILVER;
            case "TEAL" -> Color.TEAL;
            case "WHITE" -> Color.WHITE;
            case "YELLOW" -> Color.YELLOW;
            default -> null;
        };
    }

    public static void setMPState(boolean miniplaceholders) {
        TextUtil.miniplaceholders = miniplaceholders;
    }
}

