/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.util;

import com.cryptomorin.xseries.XMaterial;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.hook.hooks.head.HeadHook;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ItemStackBuilder {
    private static final ItemStack MALFORMED_ITEM;
    private static final AkropolisPlugin PLUGIN;
    private final ItemStack itemStack;

    public ItemStackBuilder(ItemStack item) {
        this.itemStack = item;
    }

    public static ItemStackBuilder getItemStack(ConfigurationSection section, Player player) {
        Object data;
        String username;
        ItemStack item = ItemStackBuilder.parseMaterial(section);
        ItemStackBuilder builder = new ItemStackBuilder(item);
        if (section.contains("amount")) {
            builder.withAmount(section.getInt("amount"));
        }
        if (section.contains("unbreakable")) {
            builder.setUnbreakable(section.getBoolean("unbreakable"));
        }
        if ((username = section.getString("username")) != null && section.contains("username")) {
            if (player != null) {
                String playerName = TextUtil.raw(PlaceholderUtil.setPlaceholders(username, (Audience)player));
                OfflinePlayer skullPlayer = Bukkit.getOfflinePlayer((String)playerName);
                builder.setSkullOwner(skullPlayer);
            } else if (username.equals("<player>")) {
                builder.withKey("player-head", PersistentDataType.BOOLEAN, true);
            } else {
                builder.setSkullOwner(Bukkit.getOfflinePlayer((String)username));
            }
        }
        if (section.contains("display_name")) {
            Component displayName = TextUtil.parse(section.getString("display_name"));
            builder.withName(displayName, player);
        }
        if (section.contains("lore")) {
            ArrayList<Component> lore = new ArrayList<Component>();
            for (String line : section.getStringList("lore")) {
                lore.add(TextUtil.parse(line));
            }
            if (player != null) {
                builder.withLore(lore, player);
            } else {
                builder.withLore(lore);
            }
        }
        if (section.contains("glow") && section.getBoolean("glow")) {
            builder.withGlow();
        }
        if (section.contains("item_flags")) {
            ArrayList flags = new ArrayList();
            section.getStringList("item_flags").forEach(text -> {
                try {
                    ItemFlag flag = ItemFlag.valueOf((String)text);
                    flags.add(flag);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
            builder.withFlags(flags.toArray(new ItemFlag[0]));
        }
        if (section.contains("custom_model_data")) {
            data = section.getStringList("custom_model_data");
            builder.withCustomModelData((List<String>)data);
        }
        if (section.contains("custom_item_model")) {
            data = section.getString("custom_item_model");
            builder.withCustomItemModel((String)data);
        }
        if (section.contains("enchantments")) {
            List rawEnchantments = section.getStringList("enchantments");
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (String enchantment : rawEnchantments) {
                String[] parts = enchantment.split(":");
                Enchantment enchant = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(NamespacedKey.fromString((String)parts[0].toLowerCase()));
                int level = Integer.parseInt(parts[1]);
                enchantments.put(enchant, level);
            }
            builder.withEnchantments(enchantments);
        }
        if (section.contains("tooltip_style")) {
            data = section.getString("tooltip_style");
            builder.withCustomTooltipStyle((String)data);
        }
        return builder;
    }

    public static ItemStackBuilder getItemStack(ConfigurationSection section) {
        return ItemStackBuilder.getItemStack(section, null);
    }

    public static ItemStack parseMaterial(ConfigurationSection section) {
        String rawMaterial = section.getString("material");
        if (rawMaterial == null) {
            PLUGIN.getLogger().severe("Could not get material from configuration section!");
            return MALFORMED_ITEM;
        }
        Optional xmaterial = XMaterial.matchXMaterial((String)rawMaterial);
        if (xmaterial.isEmpty()) {
            PLUGIN.getLogger().severe("Could not parse material '" + rawMaterial + "'.");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return MALFORMED_ITEM;
        }
        ItemStack item = ((XMaterial)xmaterial.get()).parseItem();
        if (item != null && item.getType() == XMaterial.PLAYER_HEAD.get()) {
            if (section.contains("base64")) {
                item = ((HeadHook)((Object)PLUGIN.getHookManager().getPluginHook("BASE64"))).getHead(section.getString("base64"));
            } else if (section.contains("hdb") && PLUGIN.getHookManager().isHookEnabled("HEAD_DATABASE")) {
                item = ((HeadHook)((Object)PLUGIN.getHookManager().getPluginHook("HEAD_DATABASE"))).getHead(section.getString("hdb"));
            }
        }
        return item;
    }

    public void withAmount(int amount) {
        this.itemStack.setAmount(amount);
    }

    public void setUnbreakable(boolean unbreakable) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not set item if the item is unbreakable or not!");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return;
        }
        itemMeta.setUnbreakable(unbreakable);
        this.itemStack.setItemMeta(itemMeta);
    }

    public void withFlags(ItemFlag ... flags) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not apply item flags!");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return;
        }
        if (Arrays.asList(flags).contains(ItemFlag.HIDE_ATTRIBUTES) && !itemMeta.hasAttributeModifiers()) {
            itemMeta.setAttributeModifiers(this.itemStack.getType().getDefaultAttributeModifiers());
        }
        itemMeta.addItemFlags(flags);
        this.itemStack.setItemMeta(itemMeta);
    }

    public void withName(Component name, Player player) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not apply item name with placeholder!");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return;
        }
        name = PlaceholderUtil.setPlaceholders(TextUtil.raw(name), (Audience)player).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
        itemMeta.displayName(name);
        this.itemStack.setItemMeta(itemMeta);
    }

    public ItemStackBuilder setSkullOwner(OfflinePlayer owner) {
        try {
            SkullMeta itemMeta = (SkullMeta)this.itemStack.getItemMeta();
            if (itemMeta == null) {
                PLUGIN.getLogger().severe("Invalid item meta, could not set skull owner!");
                PLUGIN.getLogger().severe("Please check your config.yml!");
                return new ItemStackBuilder(MALFORMED_ITEM);
            }
            itemMeta.setOwningPlayer(owner);
            this.itemStack.setItemMeta((ItemMeta)itemMeta);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public void withLore(List<Component> lore, Player player) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not apply lore with placeholders!");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return;
        }
        ArrayList<Component> coloredLore = new ArrayList<Component>();
        for (Component line : lore) {
            line = PlaceholderUtil.setPlaceholders(TextUtil.raw(line), (Audience)player);
            line = line.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
            coloredLore.add(line);
        }
        itemMeta.lore(coloredLore);
        this.itemStack.setItemMeta(itemMeta);
    }

    public void withLore(List<Component> lore) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not apply lore!");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return;
        }
        ArrayList<Component> nonItalicLore = new ArrayList<Component>();
        for (Component line : lore) {
            line = line.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
            nonItalicLore.add(line);
        }
        itemMeta.lore(nonItalicLore);
        this.itemStack.setItemMeta(itemMeta);
    }

    public void withGlow() {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not apply glow!");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return;
        }
        itemMeta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        this.itemStack.setItemMeta(itemMeta);
    }

    public void withEnchantments(Map<Enchantment, Integer> enchantments) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not apply enchantments!");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return;
        }
        enchantments.forEach((enchantment, level) -> itemMeta.addEnchant(enchantment, level.intValue(), true));
        this.itemStack.setItemMeta(itemMeta);
    }

    public void withCustomModelData(List<String> data) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not apply custom model data!");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return;
        }
        CustomModelDataComponent modelDataComponent = itemMeta.getCustomModelDataComponent();
        ArrayList<Float> floats = new ArrayList<Float>();
        ArrayList<String> strings = new ArrayList<String>();
        for (String value : data) {
            try {
                float floatValue = Float.parseFloat(value);
                floats.add(Float.valueOf(floatValue));
            }
            catch (Exception exception) {
                strings.add(value);
            }
        }
        floats.addAll(modelDataComponent.getFloats());
        strings.addAll(modelDataComponent.getStrings());
        modelDataComponent.setFloats(floats);
        modelDataComponent.setStrings(strings);
        itemMeta.setCustomModelDataComponent(modelDataComponent);
        this.itemStack.setItemMeta(itemMeta);
    }

    public void withCustomItemModel(String data) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.setItemModel(NamespacedKey.fromString((String)data));
        this.itemStack.setItemMeta(itemMeta);
    }

    public void withCustomTooltipStyle(String data) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not apply custom tooltip style!");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return;
        }
        itemMeta.setTooltipStyle(NamespacedKey.fromString((String)data));
        this.itemStack.setItemMeta(itemMeta);
    }

    public <P, C> void withKey(String key, PersistentDataType<P, C> type, C value) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not apply NBT!");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return;
        }
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        container.set(NamespacedKey.minecraft((String)key), type, value);
        this.itemStack.setItemMeta(itemMeta);
    }

    public ItemStack build() {
        if (this.itemStack.getItemMeta() == null) {
            PLUGIN.getLogger().severe("Invalid item meta, could not build item.");
            PLUGIN.getLogger().severe("Please check your config.yml!");
            return MALFORMED_ITEM;
        }
        return this.itemStack;
    }

    static {
        PLUGIN = AkropolisPlugin.getInstance();
        MALFORMED_ITEM = new ItemStack(Material.BARRIER);
        ItemMeta malformedMeta = MALFORMED_ITEM.getItemMeta();
        malformedMeta.displayName(TextUtil.parse("<red>Malformed item, check your config.yml!"));
        MALFORMED_ITEM.setItemMeta(malformedMeta);
    }
}

