/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.visual.scoreboard;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.visual.scoreboard.ScoreboardHelper;
import me.zetastormy.akropolis.module.modules.visual.scoreboard.ScoreboardUpdateTask;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ScoreboardManager
extends Module
implements LifeCycle {
    private int scoreTask;
    private Map<UUID, ScoreboardHelper> players;
    private long joinDelay;
    private long worldDelay;
    private String title;
    private List<String> lines;

    public ScoreboardManager(AkropolisPlugin plugin) {
        super(plugin, ModuleType.SCOREBOARD);
    }

    @Override
    public void onEnable() {
        this.players = new HashMap<UUID, ScoreboardHelper>();
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.title = config.getString("scoreboard.title");
        this.lines = config.getStringList("scoreboard.lines");
        this.joinDelay = config.getLong("scoreboard.display_delay.server_enter", 0L);
        this.worldDelay = config.getLong("scoreboard.display_delay.world_change", 0L);
        if (config.getBoolean("scoreboard.refresh.enabled")) {
            this.scoreTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), (Runnable)new ScoreboardUpdateTask(this), 0L, config.getLong("scoreboard.refresh.rate"));
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getPlugin(), () -> Bukkit.getOnlinePlayers().stream().filter(player -> !this.inDisabledWorld(player.getLocation())).forEach(this::createScoreboard), 20L);
    }

    @Override
    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.scoreTask);
        Bukkit.getOnlinePlayers().forEach(this::removeScoreboard);
    }

    public void createScoreboard(Player player) {
        this.players.put(player.getUniqueId(), this.updateScoreboard(player.getUniqueId()));
    }

    public ScoreboardHelper updateScoreboard(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return null;
        }
        ScoreboardHelper helper = this.players.get(player.getUniqueId());
        if (helper == null) {
            helper = new ScoreboardHelper(player);
        }
        helper.setTitle(this.title);
        helper.setLinesFromList(this.lines);
        helper.addPlayer();
        return helper;
    }

    public void removeScoreboard(Player player) {
        if (this.players.containsKey(player.getUniqueId())) {
            this.players.get(player.getUniqueId()).removePlayer();
            this.players.remove(player.getUniqueId());
            org.bukkit.scoreboard.ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
            player.setScoreboard(scoreboardManager.getNewScoreboard());
        }
    }

    public boolean hasScore(UUID uuid) {
        return this.players.containsKey(uuid);
    }

    public Collection<UUID> getPlayers() {
        return this.players.keySet();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.inDisabledWorld(player.getLocation()) && !this.hasScore(player.getUniqueId())) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getPlugin(), () -> this.createScoreboard(player), this.joinDelay);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.removeScoreboard(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        World fromWorld = event.getFrom().getWorld();
        World toWorld = event.getTo().getWorld();
        if (toWorld == null) {
            return;
        }
        if (fromWorld == toWorld) {
            return;
        }
        if (this.inDisabledWorld(toWorld) && this.players.containsKey(player.getUniqueId())) {
            this.removeScoreboard(player);
        } else if (!this.players.containsKey(player.getUniqueId())) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getPlugin(), () -> this.createScoreboard(player), this.worldDelay);
        }
    }
}

