/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.visual.nametag;

import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.libs.scoreboardlibrary.api.team.ScoreboardTeam;
import me.zetastormy.akropolis.module.modules.visual.nametag.NametagHelper;
import me.zetastormy.akropolis.module.modules.visual.nametag.NametagManager;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class NametagUpdateTask
implements Runnable {
    private final NametagHelper nametagHelper;
    private final String prefix;
    private final TextColor color;
    private final String suffix;

    public NametagUpdateTask(NametagManager nametagManager, NametagHelper nametagHelper) {
        this.nametagHelper = nametagHelper;
        ConfigurationSection format = nametagManager.getConfig(ConfigType.SETTINGS).getConfigurationSection("nametag.format");
        this.prefix = format == null ? "" : format.getString("prefix");
        this.color = TextColor.fromHexString((String)(format == null ? "#FFFFFF" : format.getString("name_color", "#FFFFFF")));
        this.suffix = format == null ? "" : format.getString("suffix");
    }

    @Override
    public void run() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            ScoreboardTeam team = this.nametagHelper.getMainTeamManager().team(player.getName());
            if (team == null) {
                return;
            }
            Component prefix = PlaceholderUtil.setPlaceholders(this.prefix, (Audience)player);
            Component suffix = PlaceholderUtil.setPlaceholders(this.suffix, (Audience)player);
            this.nametagHelper.updateFormat(team.defaultDisplay(), prefix, this.color, suffix);
        });
    }
}

