/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.visual.nametag;

import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.visual.nametag.NametagHelper;
import me.zetastormy.akropolis.module.modules.visual.nametag.NametagUpdateTask;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class NametagManager
extends Module
implements LifeCycle {
    private ConfigurationSection format;
    private NametagHelper nametagHelper;
    private int nametagTask;

    public NametagManager(AkropolisPlugin plugin) {
        super(plugin, ModuleType.NAMETAG);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.format = config.getConfigurationSection("nametag.format");
        this.nametagHelper = new NametagHelper();
        if (config.getBoolean("nametag.refresh.enabled")) {
            this.nametagTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), (Runnable)new NametagUpdateTask(this, this.nametagHelper), 0L, config.getLong("nametag.refresh.rate"));
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getPlugin(), () -> Bukkit.getOnlinePlayers().forEach(player -> {
            Component prefix = PlaceholderUtil.setPlaceholders(this.format.getString("prefix"), (Audience)player);
            TextColor color = TextColor.fromHexString((String)this.format.getString("name_color", "#FFFFFF"));
            Component suffix = PlaceholderUtil.setPlaceholders(this.format.getString("suffix"), (Audience)player);
            this.nametagHelper.createFormat(prefix, color, suffix, (Player)player);
        }), 20L);
    }

    @Override
    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.nametagTask);
        Bukkit.getOnlinePlayers().forEach(this.nametagHelper::deleteFormat);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getWorld())) {
            return;
        }
        Component prefix = PlaceholderUtil.setPlaceholders(this.format.getString("prefix"), (Audience)player);
        TextColor color = TextColor.fromHexString((String)this.format.getString("name_color", "#FFFFFF"));
        Component suffix = PlaceholderUtil.setPlaceholders(this.format.getString("suffix"), (Audience)player);
        this.nametagHelper.createFormat(prefix, color, suffix, player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.nametagHelper.deleteFormat(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        World fromWorld = event.getFrom().getWorld();
        World toWorld = event.getTo().getWorld();
        if (toWorld == null) {
            return;
        }
        if (fromWorld == toWorld) {
            return;
        }
        if (this.inDisabledWorld(toWorld)) {
            this.nametagHelper.deleteFormat(player);
        } else {
            Component prefix = PlaceholderUtil.setPlaceholders(this.format.getString("prefix"), (Audience)player);
            TextColor color = TextColor.fromHexString((String)this.format.getString("name_color", "#FFFFFF"));
            Component suffix = PlaceholderUtil.setPlaceholders(this.format.getString("suffix"), (Audience)player);
            this.nametagHelper.createFormat(prefix, color, suffix, player);
        }
    }
}

