/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.visual.nametag;

import java.util.HashMap;
import java.util.Map;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.libs.scoreboardlibrary.api.team.ScoreboardTeam;
import me.zetastormy.akropolis.libs.scoreboardlibrary.api.team.TeamDisplay;
import me.zetastormy.akropolis.libs.scoreboardlibrary.api.team.TeamManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;

public class NametagHelper {
    private final TeamManager mainTeamManager = AkropolisPlugin.getInstance().getScoreboardLibrary().createTeamManager();
    private final Map<Player, ScoreboardTeam> teams = new HashMap<Player, ScoreboardTeam>();

    public void createFormat(Component prefix, TextColor color, Component suffix, Player player) {
        if (this.teams.containsKey(player)) {
            ScoreboardTeam team = this.teams.get(player);
            TeamDisplay teamDisplay = team.defaultDisplay();
            team.teamManager().addPlayer(player);
            this.updateFormat(teamDisplay, prefix, color, suffix);
            teamDisplay.addEntry(player.getName());
            return;
        }
        ScoreboardTeam team = this.mainTeamManager.createIfAbsent(player.getName());
        TeamDisplay teamDisplay = team.defaultDisplay();
        team.teamManager().addPlayer(player);
        this.updateFormat(teamDisplay, prefix, color, suffix);
        teamDisplay.addEntry(player.getName());
        this.teams.put(player, team);
    }

    public void updateFormat(TeamDisplay teamDisplay, Component prefix, TextColor color, Component suffix) {
        teamDisplay.prefix((ComponentLike)prefix);
        teamDisplay.playerColor(NamedTextColor.nearestTo((TextColor)color));
        teamDisplay.suffix((ComponentLike)suffix);
    }

    public void deleteFormat(Player player) {
        if (!this.teams.containsKey(player) || this.mainTeamManager.closed()) {
            return;
        }
        ScoreboardTeam team = this.teams.get(player);
        if (team != null) {
            team.teamManager().removePlayer(player);
            team.defaultDisplay().removeEntry(player.getName());
        }
    }

    public TeamManager getMainTeamManager() {
        return this.mainTeamManager;
    }
}

