/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.hotbar.items;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarItem;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarManager;
import me.zetastormy.akropolis.util.ItemStackBuilder;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PlayerHider
extends HotbarItem {
    private final List<UUID> hidden = new ArrayList<UUID>();
    private final ItemStack hiddenItem;
    private final ItemStack notHiddenItem;
    private final boolean playersHidden;
    private final int cooldown;

    public PlayerHider(HotbarManager hotbarManager, ItemStack item, int slot, String keyValue) {
        super(hotbarManager, item, slot, keyValue);
        FileConfiguration config = this.getHotbarManager().getConfig(ConfigType.SETTINGS);
        ItemStack hiddenItem = ItemStackBuilder.getItemStack(config.getConfigurationSection("player_hider.hidden")).build();
        ItemStack notHiddenItem = ItemStackBuilder.getItemStack(config.getConfigurationSection("player_hider.not_hidden")).build();
        ItemMeta hiddenMeta = hiddenItem.getItemMeta();
        PersistentDataContainer hiddenContainer = hiddenMeta.getPersistentDataContainer();
        hiddenContainer.set(NamespacedKey.minecraft((String)"hotbar-item"), PersistentDataType.STRING, (Object)keyValue);
        ItemMeta notHiddenMeta = notHiddenItem.getItemMeta();
        PersistentDataContainer notHiddenContainer = notHiddenMeta.getPersistentDataContainer();
        notHiddenContainer.set(NamespacedKey.minecraft((String)"hotbar-item"), PersistentDataType.STRING, (Object)keyValue);
        hiddenItem.setItemMeta(hiddenMeta);
        notHiddenItem.setItemMeta(notHiddenMeta);
        this.hiddenItem = hiddenItem;
        this.notHiddenItem = notHiddenItem;
        this.playersHidden = config.getBoolean("join_settings.players_hidden");
        this.cooldown = config.getInt("player_hider.cooldown");
    }

    @Override
    protected void onInteract(Player player) {
        if (!this.getHotbarManager().tryCooldown(player.getUniqueId(), "player_hider", this.cooldown)) {
            Message.COOLDOWN_ACTIVE.sendWithReplacement((Audience)player, "time", (Component)Component.text((long)this.getHotbarManager().getCooldown(player.getUniqueId(), "player_hider")));
            return;
        }
        if (!this.hidden.contains(player.getUniqueId())) {
            for (Player pl : Bukkit.getServer().getOnlinePlayers()) {
                player.hidePlayer(pl);
            }
            this.hidden.add(player.getUniqueId());
            Message.PLAYER_HIDER_HIDDEN.send((Audience)player);
            player.getInventory().setItem(this.getSlot(), this.hiddenItem);
        } else {
            for (Player pl : Bukkit.getServer().getOnlinePlayers()) {
                player.showPlayer(pl);
            }
            this.hidden.remove(player.getUniqueId());
            Message.PLAYER_HIDER_SHOWN.send((Audience)player);
            player.getInventory().setItem(this.getSlot(), this.notHiddenItem);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.hidden.contains(player.getUniqueId())) {
            for (Player pl : Bukkit.getServer().getOnlinePlayers()) {
                player.showPlayer(pl);
            }
        }
        this.hidden.remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player playerToHide = event.getPlayer();
        this.hidden.forEach(uuid -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                return;
            }
            player.hidePlayer(playerToHide);
        });
        if (this.playersHidden) {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                playerToHide.hidePlayer(player);
            }
            this.hidden.add(playerToHide.getUniqueId());
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.getHotbarManager().inDisabledWorld(player.getLocation()) && this.hidden.contains(player.getUniqueId())) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                player.showPlayer(p);
            }
            this.hidden.remove(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawnEvent(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.hidden.contains(player.getUniqueId())) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                player.showPlayer(p);
            }
            this.hidden.remove(player.getUniqueId());
        }
    }
}

