/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.hotbar;

import java.util.ArrayList;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarManager;
import me.zetastormy.akropolis.util.ItemStackBuilder;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class HotbarItem
implements Listener {
    private final HotbarManager hotbarManager;
    private final ItemStack item;
    private ConfigurationSection configurationSection;
    private final String keyValue;
    private String permission = null;
    private final int slot;
    private boolean disableMovement;

    protected HotbarItem(HotbarManager hotbarManager, ItemStack item, int slot, String keyValue) {
        this.hotbarManager = hotbarManager;
        this.keyValue = keyValue;
        this.slot = slot;
        ItemMeta itemMeta = item.getItemMeta();
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        container.set(NamespacedKey.minecraft((String)"hotbar-item"), PersistentDataType.STRING, (Object)keyValue);
        item.setItemMeta(itemMeta);
        this.item = item;
    }

    public AkropolisPlugin getPlugin() {
        return this.hotbarManager.getPlugin();
    }

    public HotbarManager getHotbarManager() {
        return this.hotbarManager;
    }

    public ItemStack getItem() {
        return this.item;
    }

    protected abstract void onInteract(Player var1);

    public String getKeyValue() {
        return this.keyValue;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setDisableMovement(boolean disableMovement) {
        this.disableMovement = disableMovement;
    }

    public void setConfigurationSection(ConfigurationSection configurationSection) {
        this.configurationSection = configurationSection;
    }

    public ConfigurationSection getConfigurationSection() {
        return this.configurationSection;
    }

    public void giveItem(Player player) {
        if (this.permission != null && !player.hasPermission(this.permission)) {
            return;
        }
        ItemStack newItem = this.item.clone();
        if (this.getConfigurationSection() != null && this.getConfigurationSection().contains("username")) {
            String skullName = TextUtil.raw(PlaceholderUtil.setPlaceholders(this.getConfigurationSection().getString("username", player.getName()), (Audience)player));
            OfflinePlayer skullPlayer = Bukkit.getOfflinePlayer((String)skullName);
            newItem = new ItemStackBuilder(newItem).setSkullOwner(skullPlayer).build();
        }
        player.getInventory().setItem(this.slot, newItem);
        this.hotbarManager.getPlayers().add(player.getUniqueId());
    }

    public void removeItem(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack itemInSlot = inventory.getItem(this.slot);
        if (itemInSlot == null) {
            return;
        }
        PersistentDataContainer container = itemInSlot.getItemMeta().getPersistentDataContainer();
        String keyValueInItem = (String)container.get(NamespacedKey.minecraft((String)"hotbar-item"), PersistentDataType.STRING);
        if (keyValueInItem != null && keyValueInItem.equals(this.keyValue)) {
            inventory.remove(itemInSlot);
        }
        this.hotbarManager.getPlayers().remove(player.getUniqueId());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!this.disableMovement) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.getHotbarManager().inDisabledWorld(player.getLocation())) {
            return;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(event.getCurrentItem());
        items.add(event.getCursor());
        items.add(event.getClick() == ClickType.NUMBER_KEY ? player.getInventory().getItem(event.getHotbarButton()) : event.getCurrentItem());
        for (ItemStack item : items) {
            PersistentDataContainer container;
            String keyValueInItem;
            if (item == null || item.getType() == Material.AIR || (keyValueInItem = (String)(container = item.getItemMeta().getPersistentDataContainer()).get(NamespacedKey.minecraft((String)"hotbar-item"), PersistentDataType.STRING)) == null || !keyValueInItem.equals(this.keyValue)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBookEdit(PlayerEditBookEvent event) {
        Player player = event.getPlayer();
        if (this.getHotbarManager().inDisabledWorld(player.getLocation())) {
            return;
        }
        PersistentDataContainer container = event.getPreviousBookMeta().getPersistentDataContainer();
        String keyValueInItem = (String)container.get(NamespacedKey.minecraft((String)"hotbar-item"), PersistentDataType.STRING);
        if (keyValueInItem != null && keyValueInItem.equals(this.keyValue)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void hotbarItemInteract(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getItemInHand();
        if (this.getHotbarManager().inDisabledWorld(player.getLocation()) || itemInHand.getType() == Material.AIR) {
            return;
        }
        PersistentDataContainer container = itemInHand.getItemMeta().getPersistentDataContainer();
        String keyValueInItem = (String)container.get(NamespacedKey.minecraft((String)"hotbar-item"), PersistentDataType.STRING);
        if (keyValueInItem == null || !keyValueInItem.equals(this.keyValue)) {
            return;
        }
        this.onInteract(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void hotbarPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.getHotbarManager().inDisabledWorld(player.getLocation())) {
            this.giveItem(player);
        }
    }

    @EventHandler
    public void hotbarPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!this.getHotbarManager().inDisabledWorld(player.getLocation())) {
            this.removeItem(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void hotbarWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> {
            if (this.getHotbarManager().inDisabledWorld(player.getLocation())) {
                this.removeItem(player);
            } else {
                this.giveItem(player);
            }
        }, 5L);
    }

    @EventHandler
    public void hotbarPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!this.getHotbarManager().inDisabledWorld(player.getLocation())) {
            this.giveItem(player);
        }
    }
}

