/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.hologram;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigHandler;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.hologram.Hologram;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class HologramManager
extends Module
implements LifeCycle {
    private Set<Hologram> holograms;
    private ConfigHandler dataConfig;
    private ConfigurationSection hologramsSection;

    public HologramManager(AkropolisPlugin plugin) {
        super(plugin, ModuleType.HOLOGRAMS);
    }

    @Override
    public void onEnable() {
        this.holograms = new HashSet<Hologram>();
        this.dataConfig = this.getPlugin().getConfigManager().getFile(ConfigType.DATA);
        this.hologramsSection = this.getConfig(ConfigType.DATA).getConfigurationSection("holograms");
        if (this.hologramsSection == null) {
            this.getPlugin().getLogger().info("No holograms to load!");
            return;
        }
        this.loadHolograms();
    }

    @Override
    public void onDisable() {
        this.saveHolograms();
    }

    public void loadHolograms() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> {
            for (String key : this.hologramsSection.getKeys(false)) {
                List rawLines = this.hologramsSection.getStringList(key + ".lines");
                ArrayList<Component> lines = new ArrayList<Component>();
                rawLines.forEach(l -> lines.add(TextUtil.parse(l)));
                Location location = (Location)this.hologramsSection.get(key + ".location");
                if (location == null) continue;
                this.deleteNearbyHolograms(location);
                this.createHologram(key, location).setLines(lines);
            }
        }, 40L);
    }

    public void saveHolograms() {
        this.holograms.forEach(hologram -> {
            this.dataConfig.get().set("holograms." + hologram.getName() + ".location", (Object)hologram.getLocation());
            ArrayList<String> lines = new ArrayList<String>();
            for (ArmorStand stand : hologram.getStands()) {
                Component standName = stand.customName();
                if (standName == null) continue;
                lines.add(TextUtil.raw(standName));
            }
            this.dataConfig.get().set("holograms." + hologram.getName() + ".lines", lines);
        });
        this.dataConfig.save();
        this.removeAllHolograms();
    }

    public Set<Hologram> getHolograms() {
        return this.holograms;
    }

    public boolean hasHologram(String name) {
        return this.getHolograms().stream().anyMatch(hologram -> hologram.getName().equalsIgnoreCase(name));
    }

    public Hologram getHologram(String name) {
        return this.getHolograms().stream().filter(hologram -> hologram.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public Hologram createHologram(String name, Location location) {
        Hologram holo = new Hologram(name, location);
        this.holograms.add(holo);
        return holo;
    }

    public void deleteHologram(String name) {
        Hologram holo = this.getHologram(name);
        holo.remove();
        this.holograms.remove(holo);
        if (this.hologramsSection != null && this.hologramsSection.get(name) != null) {
            this.hologramsSection.set(name, null);
            this.getPlugin().getConfigManager().getFile(ConfigType.DATA).save();
        }
    }

    public void removeAllHolograms() {
        this.holograms.forEach(Hologram::remove);
        this.holograms.clear();
    }

    public void deleteNearbyHolograms(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.getNearbyEntities(location, 0.0, 20.0, 0.0).stream().filter(entity -> entity instanceof ArmorStand).forEach(Entity::remove);
    }
}

