/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.chat;

import com.cryptomorin.xseries.XSound;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AutoBroadcast
extends Module
implements Runnable,
LifeCycle {
    private Map<Integer, List<String>> broadcasts;
    private int broadcastTask = 0;
    private int count = 0;
    private int size = 0;
    private int requiredPlayers = 0;
    private Sound sound = null;
    private double volume;
    private double pitch;

    public AutoBroadcast(AkropolisPlugin plugin) {
        super(plugin, ModuleType.ANNOUNCEMENTS);
    }

    @Override
    public void onEnable() {
        String soundValue;
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.broadcasts = new HashMap<Integer, List<String>>();
        int announcementsCount = 0;
        ConfigurationSection announcementsSettings = config.getConfigurationSection("announcements");
        if (announcementsSettings == null) {
            this.getPlugin().getLogger().severe("Announcement settings configuration section is missing!");
            return;
        }
        ConfigurationSection announcements = announcementsSettings.getConfigurationSection("announcements");
        if (announcements == null) {
            this.getPlugin().getLogger().severe("Announcements are missing in the configuration!");
            return;
        }
        for (String key : announcements.getKeys(false)) {
            this.broadcasts.put(announcementsCount, announcements.getStringList(key));
            ++announcementsCount;
        }
        if (announcementsSettings.getBoolean("sound.enabled") && (soundValue = announcementsSettings.getString("sound.value")) != null) {
            XSound.of((String)soundValue).ifPresent(s -> {
                this.sound = (Sound)s.get();
            });
            this.volume = announcementsSettings.getDouble("sound.volume");
            this.pitch = announcementsSettings.getDouble("sound.pitch");
        }
        this.requiredPlayers = announcementsSettings.getInt("required_players", 0);
        this.size = this.broadcasts.size();
        if (this.size > 0) {
            this.broadcastTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), (Runnable)this, 60L, announcementsSettings.getLong("delay") * 20L);
        }
    }

    @Override
    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.broadcastTask);
    }

    @Override
    public void run() {
        if (this.count == this.size) {
            this.count = 0;
        }
        if (this.count >= this.size || Bukkit.getOnlinePlayers().size() < this.requiredPlayers) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.inDisabledWorld(player.getLocation())) continue;
            this.broadcasts.get(this.count).forEach(message -> {
                Component parsedMessage = PlaceholderUtil.setPlaceholders(message, (Audience)player);
                player.sendMessage(parsedMessage);
            });
            if (this.sound == null) continue;
            player.playSound(player.getLocation(), this.sound, (float)this.volume, (float)this.pitch);
        }
        ++this.count;
    }
}

