/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.chat.AntiSwear;
import me.zetastormy.akropolis.module.modules.chat.AutoBroadcast;
import me.zetastormy.akropolis.module.modules.chat.ChatCommandBlock;
import me.zetastormy.akropolis.module.modules.chat.ChatLock;
import me.zetastormy.akropolis.module.modules.chat.groups.ChatGroups;
import me.zetastormy.akropolis.module.modules.hologram.HologramManager;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarManager;
import me.zetastormy.akropolis.module.modules.player.DoubleJump;
import me.zetastormy.akropolis.module.modules.player.FightModeManager;
import me.zetastormy.akropolis.module.modules.player.PlayerListener;
import me.zetastormy.akropolis.module.modules.player.PlayerMount;
import me.zetastormy.akropolis.module.modules.player.PlayerOffHandSwap;
import me.zetastormy.akropolis.module.modules.player.PlayerVanish;
import me.zetastormy.akropolis.module.modules.visual.bossbar.BossBarBroadcast;
import me.zetastormy.akropolis.module.modules.visual.nametag.NametagManager;
import me.zetastormy.akropolis.module.modules.visual.scoreboard.ScoreboardManager;
import me.zetastormy.akropolis.module.modules.visual.tablist.TablistManager;
import me.zetastormy.akropolis.module.modules.world.AntiWorldDownloader;
import me.zetastormy.akropolis.module.modules.world.Launchpad;
import me.zetastormy.akropolis.module.modules.world.LobbySpawn;
import me.zetastormy.akropolis.module.modules.world.SongPlayerManager;
import me.zetastormy.akropolis.module.modules.world.WorldProtect;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class ModuleManager
implements Listener {
    private final Map<ModuleType, Module> modules = new EnumMap<ModuleType, Module>(ModuleType.class);
    private AkropolisPlugin plugin;
    private List<String> disabledWorlds;

    public void createDisabledWorlds() {
        FileConfiguration config = this.plugin.getConfigManager().getFile(ConfigType.SETTINGS).get();
        this.disabledWorlds = config.getStringList("disabled-worlds.worlds");
        if (config.getBoolean("disabled-worlds.invert")) {
            ArrayList<String> newDisabledWorlds = new ArrayList<String>();
            for (Object world : Bukkit.getWorlds()) {
                newDisabledWorlds.add(world.getName());
            }
            this.disabledWorlds = newDisabledWorlds;
            for (Object world : config.getStringList("disabled-worlds.worlds")) {
                this.disabledWorlds.remove(world);
            }
        }
        for (Module module : this.modules.values()) {
            module.setDisabledWorlds(this.disabledWorlds);
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        FileConfiguration config = this.plugin.getConfigManager().getFile(ConfigType.SETTINGS).get();
        List configuredWorlds = config.getStringList("disabled-worlds.worlds");
        String worldName = event.getWorld().getName();
        if (config.getBoolean("disabled-worlds.invert")) {
            if (!configuredWorlds.contains(worldName)) {
                this.disabledWorlds.add(worldName);
            }
        } else if (configuredWorlds.contains(worldName)) {
            this.disabledWorlds.add(worldName);
        }
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        this.disabledWorlds.remove(event.getEventName());
    }

    public void loadModules(AkropolisPlugin plugin) {
        this.plugin = plugin;
        if (!this.modules.isEmpty()) {
            this.unloadModules();
        }
        this.registerModule(new AntiWorldDownloader(plugin), "anti_wdl.enabled");
        this.registerModule(new DoubleJump(plugin), "double_jump.enabled");
        this.registerModule(new PlayerMount(plugin), "player_mount.enabled");
        this.registerModule(new Launchpad(plugin), "launchpad.enabled");
        this.registerModule(new BossBarBroadcast(plugin), "boss_bar_announcements.enabled");
        this.registerModule(new NametagManager(plugin), "nametag.enabled");
        this.registerModule(new ScoreboardManager(plugin), "scoreboard.enabled");
        this.registerModule(new TablistManager(plugin), "tablist.enabled");
        this.registerModule(new AutoBroadcast(plugin), "announcements.enabled");
        this.registerModule(new AntiSwear(plugin), "anti_swear.enabled");
        this.registerModule(new ChatCommandBlock(plugin), "command_block.enabled");
        this.registerModule(new ChatGroups(plugin), "groups.enabled");
        this.registerModule(new ChatLock(plugin));
        this.registerModule(new PlayerListener(plugin));
        this.registerModule(new HotbarManager(plugin));
        this.registerModule(new WorldProtect(plugin));
        this.registerModule(new LobbySpawn(plugin));
        this.registerModule(new PlayerVanish(plugin));
        this.registerModule(new HologramManager(plugin));
        this.registerModule(new PlayerOffHandSwap(plugin), "world_settings.disable_off_hand_swap");
        this.registerModule(new FightModeManager(plugin), "fight_mode.enabled");
        this.createDisabledWorlds();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        if (plugin.getHookManager().isHookEnabled("NOTEBLOCK_API")) {
            this.registerModule(new SongPlayerManager(plugin), "song_player.enabled");
        } else {
            plugin.getLogger().warning("NoteBlockAPI is not installed and enabled! The songs module won't be enabled.");
        }
        for (Module module : this.modules.values()) {
            try {
                module.setDisabledWorlds(this.disabledWorlds);
                if (!(module instanceof LifeCycle)) continue;
                ((LifeCycle)((Object)module)).onEnable();
            }
            catch (Exception e) {
                e.printStackTrace();
                plugin.getLogger().severe("There was an error loading the " + String.valueOf((Object)module.getModuleType()) + " module");
                plugin.getLogger().severe("The plugin will now disable...");
                plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
                break;
            }
        }
        plugin.getLogger().log(Level.INFO, "Loaded {0} plugin modules.", this.modules.size());
    }

    public void unloadModules() {
        for (Module module : this.modules.values()) {
            try {
                HandlerList.unregisterAll((Listener)module);
                if (!(module instanceof LifeCycle)) continue;
                ((LifeCycle)((Object)module)).onDisable();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.plugin.getLogger().severe("There was an error unloading the " + module.getModuleType().toString() + " module.");
            }
        }
        HandlerList.unregisterAll((Listener)this);
        this.modules.clear();
    }

    public Module getModule(ModuleType type) {
        return this.modules.get((Object)type);
    }

    public void registerModule(Module module) {
        this.registerModule(module, null);
    }

    public void registerModule(Module module, String isEnabledPath) {
        if (isEnabledPath != null && !this.plugin.getConfigManager().getFile(ConfigType.SETTINGS).get().getBoolean(isEnabledPath, false)) {
            return;
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)module, (Plugin)this.plugin);
        this.modules.put(module.getModuleType(), module);
    }

    public boolean isEnabled(ModuleType type) {
        return this.modules.containsKey((Object)type);
    }

    public List<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }
}

