/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.objective;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import me.zetastormy.akropolis.libs.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import me.zetastormy.akropolis.libs.scoreboardlibrary.api.objective.ObjectiveRenderType;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.PacketSender;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.PacketAccessors;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.objective.DisplaySlotProvider;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.objective.ObjectiveConstants;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.util.reflect.ReflectUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractObjectivePacketAdapter
implements ObjectivePacketAdapter {
    protected final PacketSender<Packet<?>> sender;
    protected final ComponentProvider componentProvider;
    protected final String objectiveName;
    private ClientboundSetObjectivePacket removePacket;

    public AbstractObjectivePacketAdapter(@NotNull PacketSender<Packet<?>> sender, @NotNull ComponentProvider componentProvider, @NotNull String objectiveName) {
        this.sender = sender;
        this.componentProvider = componentProvider;
        this.objectiveName = objectiveName;
    }

    @Override
    @NotNull
    public String objectiveName() {
        return this.objectiveName;
    }

    @Override
    public void display(@NotNull Collection<Player> players, @NotNull ObjectiveDisplaySlot slot) {
        this.sender.sendPacket((Iterable<Player>)players, (Packet<?>)this.createDisplayPacket(slot));
    }

    @Override
    public void remove(@NotNull Collection<Player> players) {
        if (this.removePacket == null) {
            this.removePacket = ReflectUtil.getEmptyConstructor(ClientboundSetObjectivePacket.class).invoke();
            PacketAccessors.OBJECTIVE_NAME_FIELD.set(this.removePacket, this.objectiveName);
            PacketAccessors.OBJECTIVE_MODE_FIELD.set(this.removePacket, 1);
        }
        this.sender.sendPacket((Iterable<Player>)players, (Packet<?>)this.removePacket);
    }

    @Override
    public void removeScore(@NotNull Collection<Player> players, @NotNull String entry) {
        Object packet = PacketAccessors.IS_1_20_3_OR_ABOVE ? new ClientboundResetScorePacket(entry, this.objectiveName) : (Packet)Objects.requireNonNull(PacketAccessors.SCORE_1_20_2_CONSTRUCTOR).invoke(PacketAccessors.SCORE_1_20_2_METHOD_REMOVE, this.objectiveName, entry, 0);
        this.sender.sendPacket((Iterable<Player>)players, (Packet<?>)packet);
    }

    @NotNull
    protected ClientboundSetDisplayObjectivePacket createDisplayPacket(@NotNull ObjectiveDisplaySlot displaySlot) {
        ClientboundSetDisplayObjectivePacket packet = PacketAccessors.IS_1_20_2_OR_ABOVE ? new ClientboundSetDisplayObjectivePacket(DisplaySlotProvider.toNms(displaySlot), null) : Objects.requireNonNull(PacketAccessors.DISPLAY_1_20_1_CONSTRUCTOR).invoke(ObjectiveConstants.displaySlotIndex(displaySlot), null);
        PacketAccessors.DISPLAY_OBJECTIVE_NAME.set(packet, this.objectiveName);
        return packet;
    }

    @NotNull
    protected ClientboundSetScorePacket createScorePacket(@NotNull String entry, int value, @Nullable Component nmsDisplay, @Nullable Object numberFormat) {
        if (PacketAccessors.IS_1_20_5_OR_ABOVE) {
            return new ClientboundSetScorePacket(entry, this.objectiveName, value, Optional.ofNullable(nmsDisplay), Optional.ofNullable((NumberFormat)numberFormat));
        }
        if (PacketAccessors.IS_1_20_3_OR_ABOVE) {
            return Objects.requireNonNull(PacketAccessors.SCORE_1_20_3_CONSTRUCTOR).invoke(entry, this.objectiveName, value, nmsDisplay, numberFormat);
        }
        return Objects.requireNonNull(PacketAccessors.SCORE_1_20_2_CONSTRUCTOR).invoke(PacketAccessors.SCORE_1_20_2_METHOD_CHANGE, this.objectiveName, entry, value);
    }

    @NotNull
    protected ClientboundSetObjectivePacket createObjectivePacket(@NotNull PropertiesPacketType packetType, @NotNull Component nmsValue, @NotNull ObjectiveRenderType renderType, @Nullable Object numberFormat) {
        ObjectiveCriteria.RenderType nmsRenderType;
        ClientboundSetObjectivePacket packet = PacketAccessors.OBJECTIVE_PACKET_CONSTRUCTOR.invoke();
        PacketAccessors.OBJECTIVE_MODE_FIELD.set(packet, ObjectiveConstants.mode(packetType));
        PacketAccessors.OBJECTIVE_NAME_FIELD.set(packet, this.objectiveName);
        PacketAccessors.OBJECTIVE_VALUE_FIELD.set(packet, nmsValue);
        if (PacketAccessors.IS_1_20_3_OR_ABOVE) {
            assert (PacketAccessors.OBJECTIVE_NUMBER_FORMAT_FIELD != null);
            Optional<Object> value = PacketAccessors.IS_1_20_5_OR_ABOVE ? Optional.ofNullable(numberFormat) : numberFormat;
            PacketAccessors.OBJECTIVE_NUMBER_FORMAT_FIELD.set(packet, value);
        }
        switch (renderType) {
            case INTEGER: {
                nmsRenderType = ObjectiveCriteria.RenderType.INTEGER;
                break;
            }
            case HEARTS: {
                nmsRenderType = ObjectiveCriteria.RenderType.HEARTS;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        PacketAccessors.OBJECTIVE_RENDER_TYPE_FIELD.set(packet, nmsRenderType);
        return packet;
    }
}

