/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern;

import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.commons.LineRenderingStrategy;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.PacketAdapterProvider;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.PacketSender;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProviderImpl;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.objective.PaperObjectivePacketAdapter;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.objective.SpigotObjectivePacketAdapter;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.team.PaperTeamsPacketAdapterImpl;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.team.SpigotTeamsPacketAdapter;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.util.PacketUtil;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.team.TeamsPacketAdapter;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.Packet;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PacketAdapterProviderImpl
implements PacketAdapterProvider,
PacketSender<Packet<?>> {
    private boolean isNativeAdventure;
    private final ComponentProvider componentProvider;

    public PacketAdapterProviderImpl() {
        try {
            Class.forName("io.papermc.paper.adventure.PaperAdventure");
            String notRelocatedPackage = "net.ky".concat("ori.adventure.text");
            if (Component.class.getPackage().getName().equals(notRelocatedPackage)) {
                this.isNativeAdventure = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.componentProvider = new ComponentProviderImpl(this.isNativeAdventure);
    }

    @Override
    @NotNull
    public ObjectivePacketAdapter createObjectiveAdapter(@NotNull String objectiveName) {
        return this.isNativeAdventure ? new PaperObjectivePacketAdapter(this, this.componentProvider, objectiveName) : new SpigotObjectivePacketAdapter(this, this.componentProvider, objectiveName);
    }

    @Override
    @NotNull
    public TeamsPacketAdapter createTeamPacketAdapter(@NotNull String teamName) {
        return this.isNativeAdventure ? new PaperTeamsPacketAdapterImpl(this, this.componentProvider, teamName) : new SpigotTeamsPacketAdapter(this, this.componentProvider, teamName);
    }

    @Override
    @NotNull
    public LineRenderingStrategy lineRenderingStrategy(@NotNull Player player) {
        return LineRenderingStrategy.MODERN;
    }

    @Override
    public void sendPacket(@NotNull Player player, @NotNull Packet<?> packet) {
        PacketUtil.sendPacket(player, packet);
    }
}

