/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Locale;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.PacketAccessors;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.util.NativeAdventureUtil;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.util.RegistryUtil;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.util.reflect.ReflectUtil;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentProviderImpl
implements ComponentProvider {
    private static final MethodHandle FROM_JSON_METHOD;
    private final boolean isNativeAdventure;

    public ComponentProviderImpl(boolean isNativeAdventure) {
        this.isNativeAdventure = isNativeAdventure;
    }

    @Override
    public @NotNull Component fromAdventure(@NotNull net.kyori.adventure.text.Component adventure, @Nullable Locale locale) {
        if (this.isNativeAdventure) {
            return NativeAdventureUtil.fromAdventureComponent(adventure);
        }
        net.kyori.adventure.text.Component translated = adventure;
        if (locale != null) {
            translated = GlobalTranslator.render((net.kyori.adventure.text.Component)adventure, (Locale)locale);
        }
        JsonElement json = GsonComponentSerializer.gson().serializeToTree(translated);
        if (FROM_JSON_METHOD == null) {
            return (Component)ComponentSerialization.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
        }
        Object[] args = PacketAccessors.IS_1_20_5_OR_ABOVE ? new Object[]{json, RegistryUtil.MINECRAFT_REGISTRY} : new Object[]{json};
        try {
            return (Component)FROM_JSON_METHOD.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        if (!PacketAccessors.IS_1_21_6_OR_ABOVE) {
            Class<?> serializerClass = ReflectUtil.getClassOrThrow("net.minecraft.network.chat.Component$Serializer", "net.minecraft.network.chat.IChatBaseComponent$ChatSerializer");
            MethodHandle handle = null;
            for (Method method : serializerClass.getMethods()) {
                if (method.getReturnType() != MutableComponent.class || method.getParameterCount() < 1 || method.getParameterCount() > 2 || method.getParameterTypes()[0] != JsonElement.class) continue;
                try {
                    handle = MethodHandles.lookup().unreflect(method);
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
            if (handle == null) {
                throw new ExceptionInInitializerError("failed to find chat component fromJson method");
            }
            FROM_JSON_METHOD = handle;
        } else {
            FROM_JSON_METHOD = null;
        }
    }
}

