/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.objective;

import java.util.Iterator;
import java.util.logging.Level;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.objective.ObjectiveManagerImpl;
import me.zetastormy.akropolis.libs.scoreboardlibrary.implementation.scheduler.RunningTask;
import org.jetbrains.annotations.NotNull;

public class ObjectiveUpdaterTask
implements Runnable {
    private final ScoreboardLibraryImpl scoreboardLibrary;
    private final RunningTask task;
    private final Object lock = new Object();

    public ObjectiveUpdaterTask(@NotNull ScoreboardLibraryImpl scoreboardLibrary) {
        this.scoreboardLibrary = scoreboardLibrary;
        this.task = scoreboardLibrary.taskScheduler().runEveryTick(this);
    }

    @NotNull
    public RunningTask task() {
        return this.task;
    }

    @NotNull
    public Object lock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<ObjectiveManagerImpl> iterator = this.scoreboardLibrary.objectiveManagers().iterator();
            while (iterator.hasNext()) {
                boolean result;
                ObjectiveManagerImpl objectiveManager = iterator.next();
                try {
                    result = objectiveManager.tick();
                }
                catch (Exception e) {
                    this.scoreboardLibrary.plugin().getLogger().log(Level.WARNING, "an error occurred while updating an ObjectiveManager instance", e);
                    continue;
                }
                if (result) continue;
                iterator.remove();
            }
        }
    }
}

