/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.libs.scoreboardlibrary.api.sidebar.component.animation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import me.zetastormy.akropolis.libs.scoreboardlibrary.api.sidebar.component.animation.FramedSidebarAnimation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class CollectionSidebarAnimation<T>
implements FramedSidebarAnimation<T> {
    private final List<T> frames;
    private int currentFrameIndex;

    public CollectionSidebarAnimation(@NotNull Collection<T> frames) {
        Preconditions.checkNotNull(frames);
        Preconditions.checkArgument((!frames.isEmpty() ? 1 : 0) != 0);
        this.frames = ImmutableList.copyOf(frames);
    }

    @Override
    public @Unmodifiable @NotNull List<T> frames() {
        return this.frames;
    }

    @Override
    public int currentFrameIndex() {
        return this.currentFrameIndex;
    }

    @Override
    public void switchFrame(int frameIndex) {
        if (frameIndex < 0 || frameIndex >= this.frames.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrameIndex = frameIndex;
    }

    @Override
    @NotNull
    public T currentFrame() {
        return this.frames.get(this.currentFrameIndex);
    }

    @Override
    public void nextFrame() {
        if (++this.currentFrameIndex == this.frames.size()) {
            this.currentFrameIndex = 0;
        }
    }
}

