/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.libs.scoreboardlibrary.api.objective;

import com.google.common.base.Preconditions;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface ScoreFormat {
    @NotNull
    public static Blank blank() {
        return Blank.INSTANCE;
    }

    @NotNull
    public static Fixed fixed(@NotNull ComponentLike content) {
        Preconditions.checkNotNull((Object)content);
        return new Fixed(content.asComponent());
    }

    @NotNull
    public static Styled styled(@NotNull Style style) {
        Preconditions.checkNotNull((Object)style);
        return new Styled(style);
    }

    @NotNull
    public static Styled styled(StyleBuilderApplicable ... styleBuilderApplicables) {
        Preconditions.checkNotNull((Object)styleBuilderApplicables);
        return new Styled(Style.style((StyleBuilderApplicable[])styleBuilderApplicables));
    }

    public static class Blank
    implements ScoreFormat {
        private static final Blank INSTANCE = new Blank();

        private Blank() {
        }

        public String toString() {
            return "Blank";
        }
    }

    public static class Fixed
    implements ScoreFormat {
        private final Component content;

        public Fixed(@NotNull Component content) {
            this.content = content;
        }

        @NotNull
        public Component content() {
            return this.content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fixed that = (Fixed)o;
            return this.content.equals((Object)that.content);
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public String toString() {
            return "Fixed{content=" + this.content + "}";
        }
    }

    public static class Styled
    implements ScoreFormat {
        private final Style style;

        public Styled(@NotNull Style style) {
            this.style = style;
        }

        @NotNull
        public Style style() {
            return this.style;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Styled that = (Styled)o;
            return this.style.equals((Object)that.style);
        }

        public int hashCode() {
            return this.style.hashCode();
        }

        public String toString() {
            return "Styled{style=" + this.style + "}";
        }
    }
}

