/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.inventory.inventories;

import java.util.Objects;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.inventory.AbstractInventory;
import me.zetastormy.akropolis.inventory.InventoryBuilder;
import me.zetastormy.akropolis.inventory.InventoryItem;
import me.zetastormy.akropolis.util.ItemStackBuilder;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class CustomGUI
extends AbstractInventory {
    private final FileConfiguration config;
    private final ConfigurationSection itemsSection;
    private InventoryBuilder inventory;

    public CustomGUI(AkropolisPlugin plugin, FileConfiguration config) {
        super(plugin);
        this.config = config;
        this.itemsSection = config.getConfigurationSection("items");
    }

    @Override
    public void onEnable() {
        InventoryBuilder inventoryBuilder = new InventoryBuilder(this.config.getInt("slots"), this.config.getString("title"));
        if (this.config.contains("refresh") && this.config.getBoolean("refresh.enabled")) {
            this.setInventoryRefresh(this.config.getLong("refresh.rate"));
        }
        if (this.itemsSection == null) {
            this.getPlugin().getLogger().severe("Items configuration section is missing!");
            return;
        }
        for (String item : this.itemsSection.getKeys(false)) {
            try {
                InventoryItem inventoryItem = this.build(item);
                this.setFiller(inventoryBuilder, item, inventoryItem);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getPlugin().getLogger().warning("There was an error loading GUI item ID '" + item + "', skipping..");
            }
        }
        this.inventory = inventoryBuilder;
    }

    private InventoryItem build(@NotNull String itemKey) {
        ConfigurationSection itemConfig = Objects.requireNonNull(this.itemsSection.getConfigurationSection(itemKey));
        ItemStackBuilder itemStackBuilder = ItemStackBuilder.getItemStack(itemConfig);
        InventoryItem inventoryItem = !this.itemsSection.contains(itemKey + ".actions") ? new InventoryItem(itemStackBuilder.build(), itemConfig.getString("permission")) : new InventoryItem(itemStackBuilder.build(), itemConfig.getString("permission")).addClickAction(p -> this.getPlugin().getActionManager().executeActions(p, this.itemsSection.getStringList(itemKey + ".actions")));
        return inventoryItem;
    }

    private void setFiller(InventoryBuilder inventoryBuilder, String item, InventoryItem inventoryItem) {
        if (this.itemsSection.contains(item + ".slots")) {
            for (String slot : this.itemsSection.getStringList(item + ".slots")) {
                inventoryBuilder.setItem(Integer.parseInt(slot), inventoryItem);
            }
        } else if (this.itemsSection.contains(item + ".slot")) {
            int slot = this.itemsSection.getInt(item + ".slot");
            if (slot == -1) {
                while (inventoryBuilder.getInventory().firstEmpty() != -1) {
                    inventoryBuilder.setItem(inventoryBuilder.getInventory().firstEmpty(), inventoryItem);
                }
            } else {
                inventoryBuilder.setItem(slot, inventoryItem);
            }
        }
    }

    @Override
    protected Inventory getInventory() {
        return this.inventory.getInventory();
    }
}

