/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.inventory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.inventory.AbstractInventory;
import me.zetastormy.akropolis.inventory.InventoryListener;
import me.zetastormy.akropolis.inventory.inventories.CustomGUI;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class InventoryManager {
    private AkropolisPlugin plugin;
    private final Map<String, AbstractInventory> inventories = new HashMap<String, AbstractInventory>();

    public void onEnable(AkropolisPlugin plugin) {
        this.plugin = plugin;
        this.loadCustomMenus();
        this.inventories.values().forEach(AbstractInventory::onEnable);
        plugin.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)plugin);
    }

    private void loadCustomMenus() {
        File[] yamlFiles;
        File directory = new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + "menus");
        if (!directory.exists()) {
            if (!directory.mkdir()) {
                this.plugin.getLogger().severe("Could not create menus' directory!");
                this.plugin.getLogger().severe("The plugin will now disable.");
                Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
                return;
            }
            File file = new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + "menus", "serverselector.yml");
            try (InputStream inputStream = this.plugin.getResource("serverselector.yml");
                 FileOutputStream outputStream = new FileOutputStream(file);){
                if (inputStream == null) {
                    this.plugin.getLogger().severe("Resource serverselector.yml not available in plugin's JAR!");
                    this.plugin.getLogger().severe("The plugin will now disable.");
                    Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
                    return;
                }
                byte[] buffer = new byte[inputStream.available()];
                if (inputStream.read(buffer) != 0) {
                    this.plugin.getLogger().info("Resource file serverselector.yml written sucessfully!");
                }
                ((OutputStream)outputStream).write(buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        if ((yamlFiles = new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + "menus").listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"))) == null) {
            return;
        }
        for (File file : yamlFiles) {
            CustomGUI customGUI;
            String name2 = file.getName().replace(".yml", "");
            if (this.inventories.containsKey(name2)) {
                this.plugin.getLogger().warning("Inventory with name '" + file.getName() + "' already exists, skipping duplicate..");
                continue;
            }
            try {
                customGUI = new CustomGUI(this.plugin, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Could not load file '" + name2 + "' (YAML error).");
                e.printStackTrace();
                continue;
            }
            this.inventories.put(name2, customGUI);
            this.plugin.getLogger().log(Level.INFO, "Loaded custom menu {0}.", name2);
        }
    }

    public Map<String, AbstractInventory> getInventories() {
        return this.inventories;
    }

    public AbstractInventory getInventory(String key) {
        return this.inventories.get(key);
    }

    public void onDisable() {
        this.inventories.values().forEach(abstractInventory -> {
            for (UUID uuid : abstractInventory.getOpenInventories()) {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) continue;
                player.closeInventory();
            }
            abstractInventory.getOpenInventories().clear();
        });
        this.inventories.clear();
    }
}

