/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.hook;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.hook.PluginHook;
import me.zetastormy.akropolis.hook.hooks.head.BaseHead;
import me.zetastormy.akropolis.hook.hooks.head.DatabaseHead;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import me.zetastormy.akropolis.util.text.TextUtil;
import org.bukkit.Bukkit;

public class HooksManager {
    private final Map<String, PluginHook> hooks = new HashMap<String, PluginHook>();

    public HooksManager(AkropolisPlugin plugin) {
        this.hooks.put("BASE64", new BaseHead());
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.hooks.put("PLACEHOLDER_API", null);
            PlaceholderUtil.setPapiState(true);
            plugin.getLogger().info("Hooked into PlaceholderAPI");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("HeadDatabase")) {
            this.hooks.put("HEAD_DATABASE", new DatabaseHead());
            plugin.getLogger().info("Hooked into HeadDatabase");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("MiniPlaceholders")) {
            this.hooks.put("MINIPLACEHOLDERS", null);
            PlaceholderUtil.setMPState(true);
            TextUtil.setMPState(true);
            plugin.getLogger().info("Hooked into MiniPlaceholders");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("NoteBlockAPI")) {
            this.hooks.put("NOTEBLOCK_API", null);
            plugin.getLogger().info("Hooked into NoteBlockAPI");
        }
        this.hooks.values().stream().filter(Objects::nonNull).forEach(pluginHook -> pluginHook.onEnable(plugin));
    }

    public boolean isHookEnabled(String id) {
        return this.hooks.containsKey(id);
    }

    public PluginHook getPluginHook(String id) {
        return this.hooks.get(id);
    }
}

