/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.config;

import java.util.ArrayList;
import java.util.List;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.file.FileConfiguration;

public enum Message {
    PREFIX("GENERAL.PREFIX"),
    USAGE("GENERAL.USAGE"),
    NO_PERMISSION("GENERAL.NO_PERMISSION"),
    CONSOLE_NOT_ALLOWED("GENERAL.CONSOLE_NOT_ALLOWED"),
    CUSTOM_COMMAND_NO_PERMISSION("GENERAL.CUSTOM_COMMAND_NO_PERMISSION"),
    INVALID_PLAYER("GENERAL.INVALID_PLAYER"),
    CONFIG_RELOAD("GENERAL.CONFIG_RELOAD"),
    COOLDOWN_ACTIVE("GENERAL.COOLDOWN_ACTIVE"),
    HELP_PLUGIN("HELP.PLUGIN"),
    HELP_HOLOGRAM("HELP.HOLOGRAM"),
    HELP_SONG_PLAYER("HELP.SONG_PLAYER"),
    GAMEMODE_CHANGE("GAMEMODE.GAMEMODE_CHANGE"),
    GAMEMODE_CHANGE_OTHER("GAMEMODE.GAMEMODE_CHANGE_OTHER"),
    GAMEMODE_INVALID("GAMEMODE.GAMEMODE_INVALID"),
    VANISH_ENABLE("VANISH.ENABLE"),
    VANISH_DISABLE("VANISH.DISABLE"),
    FLIGHT_ENABLE("FLIGHT.ENABLE"),
    FLIGHT_ENABLE_OTHER("FLIGHT.ENABLE_OTHER"),
    FLIGHT_DISABLE("FLIGHT.DISABLE"),
    FLIGHT_DISABLE_OTHER("FLIGHT.DISABLE_OTHER"),
    PLAYER_HIDER_HIDDEN("PLAYER_HIDER.HIDDEN"),
    PLAYER_HIDER_SHOWN("PLAYER_HIDER.SHOWN"),
    SET_LOBBY("LOBBY.SET_LOBBY"),
    CLEARCHAT("CHAT.CLEARCHAT"),
    CLEARCHAT_PLAYER("CHAT.CLEARCHAT_PLAYER"),
    CHAT_LOCKED("CHAT.LOCKED"),
    CHAT_LOCKED_BROADCAST("CHAT.LOCKED_BROADCAST"),
    CHAT_UNLOCKED_BROADCAST("CHAT.UNLOCKED_BROADCAST"),
    ANTI_SWEAR_WORD_BLOCKED("CHAT.ANTI_SWEAR_WORD_BLOCKED"),
    ANTI_SWEAR_ADMIN_NOTIFY("CHAT.ANTI_SWEAR_ADMIN_NOTIFY"),
    COMMAND_BLOCKED("CHAT.COMMAND_BLOCKED"),
    SCOREBOARD_ENABLE("SCOREBOARD.ENABLE"),
    SCOREBOARD_DISABLE("SCOREBOARD.DISABLE"),
    HOTBAR_ENABLE("HOTBAR.ENABLE"),
    HOTBAR_DISABLE("HOTBAR.DISABLE"),
    DOUBLE_JUMP_COOLDOWN("DOUBLE_JUMP.COOLDOWN_ACTIVE"),
    PLAYER_MOUNT_COOLDOWN("PLAYER_MOUNT.COOLDOWN_ACTIVE"),
    EVENT_ITEM_DROP("WORLD_EVENT_MODIFICATIONS.ITEM_DROP"),
    EVENT_ITEM_PICKUP("WORLD_EVENT_MODIFICATIONS.ITEM_PICKUP"),
    EVENT_BLOCK_PLACE("WORLD_EVENT_MODIFICATIONS.BLOCK_PLACE"),
    EVENT_BLOCK_BREAK("WORLD_EVENT_MODIFICATIONS.BLOCK_BREAK"),
    EVENT_BLOCK_INTERACT("WORLD_EVENT_MODIFICATIONS.BLOCK_INTERACT"),
    EVENT_PLAYER_PVP("WORLD_EVENT_MODIFICATIONS.PLAYER_PVP"),
    HOLOGRAMS_EMPTY("HOLOGRAMS.EMPTY"),
    HOLOGRAMS_ALREADY_EXISTS("HOLOGRAMS.ALREADY_EXISTS"),
    HOLOGRAMS_INVALID_HOLOGRAM("HOLOGRAMS.INVALID_HOLOGRAM"),
    HOLOGRAMS_INVALID_LINE("HOLOGRAMS.INVALID_LINE"),
    HOLOGRAMS_SPAWNED("HOLOGRAMS.SPAWNED"),
    HOLOGRAMS_DESPAWNED("HOLOGRAMS.DESPAWNED"),
    HOLOGRAMS_MOVED("HOLOGRAMS.MOVED"),
    HOLOGRAMS_LINE_SET("HOLOGRAMS.LINE_SET"),
    HOLOGRAMS_ADDED_LINE("HOLOGRAMS.ADDED_LINE"),
    HOLOGRAMS_REMOVED_LINE("HOLOGRAMS.REMOVED_LINE"),
    SONG_PLAYER_SET_LOCATION("SONG_PLAYER.SET_LOCATION"),
    SONG_PLAYER_SKIPPED("SONG_PLAYER.SKIPPED"),
    SONG_PLAYER_NOT_LOADED("SONG_PLAYER.NOT_LOADED"),
    FIGHT_MODE_ACTIVATE_DELAY("FIGHT_MODE.ACTIVATE_DELAY"),
    FIGHT_MODE_DEACTIVATE_DELAY("FIGHT_MODE.DEACTIVATE_DELAY"),
    WORLD_DOWNLOAD_NOTIFY("ANTI_WORLD_DOWNLOADER.ADMIN_NOTIFY");

    private static FileConfiguration config;
    private final String path;

    private Message(String path) {
        this.path = path;
    }

    static void setConfiguration(FileConfiguration c) {
        config = c;
    }

    public void send(Audience audience) {
        Component messageContent = this.toComponent();
        if (messageContent.equals((Object)Component.empty())) {
            return;
        }
        audience.sendMessage(messageContent);
    }

    public void sendAsList(Audience audience) {
        List<Component> messageContent = this.toComponentList();
        if (messageContent.getFirst().equals((Object)Component.empty())) {
            return;
        }
        messageContent.forEach(arg_0 -> ((Audience)audience).sendMessage(arg_0));
    }

    public void sendWithReplacement(Audience audience, String pattern, Component replacement) {
        Component messageContent = TextUtil.replace(this.toComponent(), pattern, replacement);
        if (messageContent.equals((Object)Component.empty())) {
            return;
        }
        audience.sendMessage(messageContent);
    }

    public Component toComponent() {
        String message = config.getString("Messages." + this.path);
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        return PlaceholderUtil.setPlaceholders(message);
    }

    public List<Component> toComponentList() {
        List message = config.getStringList("Messages." + this.path);
        ArrayList<Component> componentMessage = new ArrayList<Component>();
        if (message.isEmpty()) {
            componentMessage.add((Component)Component.empty());
            return componentMessage;
        }
        message.forEach(m -> componentMessage.add(PlaceholderUtil.setPlaceholders(m)));
        return componentMessage;
    }

    public String getPath() {
        return this.path;
    }

    public String raw() {
        return config.getString("Messages." + this.path);
    }
}

