/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.command.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.Permissions;
import me.zetastormy.akropolis.command.CommandManager;
import me.zetastormy.akropolis.command.InjectableCommand;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.inventory.AbstractInventory;
import me.zetastormy.akropolis.inventory.InventoryManager;
import me.zetastormy.akropolis.module.ModuleManager;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.hologram.Hologram;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarItem;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarManager;
import me.zetastormy.akropolis.module.modules.visual.scoreboard.ScoreboardManager;
import me.zetastormy.akropolis.module.modules.world.LobbySpawn;
import me.zetastormy.akropolis.module.modules.world.SongPlayerManager;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AkropolisCommand
extends InjectableCommand {
    private final AkropolisPlugin plugin;

    public AkropolisCommand(AkropolisPlugin plugin) {
        super((Plugin)plugin, "akropolis", "View plugin information and additional commands", Collections.singletonList("akro"));
        this.plugin = plugin;
    }

    @Override
    public void onCommand(CommandSender sender, String label, String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            if (!sender.hasPermission(Permissions.COMMAND_AKROPOLIS_HELP.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            Message.HELP_PLUGIN.sendAsList((Audience)sender);
            return;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission(Permissions.COMMAND_AKROPOLIS_RELOAD.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            long start = System.currentTimeMillis();
            this.plugin.reload();
            Message.CONFIG_RELOAD.sendWithReplacement((Audience)sender, "time", TextUtil.parse(String.valueOf(System.currentTimeMillis() - start)));
        } else if (args[0].equalsIgnoreCase("scoreboard")) {
            if (!(sender instanceof Player)) {
                Message.CONSOLE_NOT_ALLOWED.send((Audience)sender);
                return;
            }
            Player player = (Player)sender;
            if (!sender.hasPermission(Permissions.COMMAND_SCOREBOARD_TOGGLE.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            if (!this.plugin.getModuleManager().isEnabled(ModuleType.SCOREBOARD)) {
                sender.sendMessage(TextUtil.parse("<red>The scoreboard module is not enabled in the configuration."));
                return;
            }
            ScoreboardManager scoreboardManager = (ScoreboardManager)this.plugin.getModuleManager().getModule(ModuleType.SCOREBOARD);
            if (scoreboardManager.hasScore(player.getUniqueId())) {
                scoreboardManager.removeScoreboard(player);
                Message.SCOREBOARD_DISABLE.send((Audience)player);
            } else {
                scoreboardManager.createScoreboard(player);
                Message.SCOREBOARD_ENABLE.send((Audience)player);
            }
        } else if (args[0].equalsIgnoreCase("hotbar")) {
            if (!(sender instanceof Player)) {
                Message.CONSOLE_NOT_ALLOWED.send((Audience)sender);
                return;
            }
            Player player = (Player)sender;
            if (!sender.hasPermission(Permissions.COMMAND_HOTBAR_TOGGLE.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            if (!this.plugin.getModuleManager().isEnabled(ModuleType.HOTBAR_ITEMS)) {
                sender.sendMessage(TextUtil.parse("<red>The hotbar module is not enabled in the configuration."));
                return;
            }
            HotbarManager hotbarManager = (HotbarManager)this.plugin.getModuleManager().getModule(ModuleType.HOTBAR_ITEMS);
            if (hotbarManager.hasHotbar(player.getUniqueId())) {
                hotbarManager.removeItemsFromPlayer(player);
                Message.HOTBAR_DISABLE.send((Audience)player);
            } else {
                hotbarManager.giveItemsToPlayer(player);
                Message.HOTBAR_ENABLE.send((Audience)player);
            }
        } else if (args[0].equalsIgnoreCase("info")) {
            if (!sender.hasPermission(Permissions.COMMAND_AKROPOLIS_HELP.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            sender.sendMessage(TextUtil.parse("<gold><b>Akropolis <reset><dark_gray>|| <gray>Plugin information<dark_gray>:"));
            Location location = ((LobbySpawn)this.plugin.getModuleManager().getModule(ModuleType.LOBBY)).getLocation();
            sender.sendMessage(TextUtil.parse("<dark_gray>\u00bb <gray>Spawn set <dark_gray>- " + (location != null ? "<green>yes" : "<red>no <gray><i>(/setlobby)")));
            ModuleManager moduleManager = this.plugin.getModuleManager();
            sender.sendMessage(TextUtil.parse("<dark_gray>\u00bb <gray>Disabled Worlds (" + moduleManager.getDisabledWorlds().size() + ") <dark_gray>- <green>" + String.join((CharSequence)", ", moduleManager.getDisabledWorlds())));
            InventoryManager inventoryManager = this.plugin.getInventoryManager();
            sender.sendMessage(TextUtil.parse("<dark_gray>\u00bb <gray>Custom menus (" + inventoryManager.getInventories().size() + ") <dark_gray>- <green>" + String.join((CharSequence)", ", inventoryManager.getInventories().keySet())));
            HotbarManager hotbarManager = (HotbarManager)this.plugin.getModuleManager().getModule(ModuleType.HOTBAR_ITEMS);
            sender.sendMessage(TextUtil.parse("<dark_gray>\u00bb <gray>Hotbar items (" + hotbarManager.getHotbarItems().size() + ") <dark_gray>- <green>" + hotbarManager.getHotbarItems().stream().map(HotbarItem::getKeyValue).collect(Collectors.joining(", "))));
            CommandManager commandManager = this.plugin.getCommandManager();
            sender.sendMessage(TextUtil.parse("<dark_gray>\u00bb <gray>Custom commands (" + commandManager.getCustomCommands().size() + ") <dark_gray>- <green>" + commandManager.getCustomCommands().stream().map(command -> (String)command.getAliases().getFirst()).collect(Collectors.joining(", "))));
            sender.sendMessage(TextUtil.parse("<dark_gray>\u00bb <gray>PlaceholderAPI hook<dark_gray>: " + (this.plugin.getHookManager().isHookEnabled("PLACEHOLDER_API") ? "<green>yes" : "<red>no")));
            sender.sendMessage(TextUtil.parse("<dark_gray>\u00bb <gray>HeadDatabase hook<dark_gray>: " + (this.plugin.getHookManager().isHookEnabled("HEAD_DATABASE") ? "<green>yes" : "<red>no")));
            sender.sendMessage(TextUtil.parse("<dark_gray>\u00bb <gray>MiniPlaceholders hook<dark_gray>: " + (this.plugin.getHookManager().isHookEnabled("MINIPLACEHOLDERS") ? "<green>yes" : "<red>no")));
            sender.sendMessage(TextUtil.parse("<dark_gray>\u00bb <gray>NoteBlockAPI hook<dark_gray>: " + (this.plugin.getHookManager().isHookEnabled("NOTEBLOCK_API") ? "<green>yes" : "<red>no")));
        } else if (args[0].equalsIgnoreCase("open")) {
            if (!(sender instanceof Player)) {
                Message.CONSOLE_NOT_ALLOWED.send((Audience)sender);
                return;
            }
            if (!sender.hasPermission(Permissions.COMMAND_OPEN_MENUS.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            if (args.length == 1) {
                Message.USAGE.sendWithReplacement((Audience)sender, "command", (Component)Component.text((String)"akropolis open <menu>"));
                return;
            }
            AbstractInventory inventory = this.plugin.getInventoryManager().getInventory(args[1]);
            if (inventory == null) {
                sender.sendMessage(TextUtil.parse("<red>" + args[1] + " is not a valid menu ID."));
                return;
            }
            inventory.openInventory((Player)sender);
        }
        if (args[0].equalsIgnoreCase("hologram") || args[0].equalsIgnoreCase("holo")) {
            Hologram holo;
            if (!(sender instanceof Player)) {
                Message.CONSOLE_NOT_ALLOWED.send((Audience)sender);
                return;
            }
            Player player = (Player)sender;
            if (!sender.hasPermission(Permissions.COMMAND_HOLOGRAMS.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            if (args.length == 1) {
                Message.HELP_HOLOGRAM.toComponentList().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                return;
            }
            if (args[1].equalsIgnoreCase("list")) {
                if (this.plugin.getHologramManager().getHolograms().isEmpty()) {
                    Message.HOLOGRAMS_EMPTY.send((Audience)sender);
                    return;
                }
                sender.sendMessage(TextUtil.parse("<gold><b>Akropolis <reset><dark_gray>|| <gray>Hologram list<dark_gray>:"));
                for (Hologram entry : this.plugin.getHologramManager().getHolograms()) {
                    sender.sendMessage(TextUtil.parse("<dark_gray>- <gray>" + entry.getName()));
                }
            }
            if (args[1].equalsIgnoreCase("create")) {
                if (args.length == 2) {
                    Message.USAGE.sendWithReplacement((Audience)sender, "command", (Component)Component.text((String)"akropolis hologram create <id>"));
                    return;
                }
                if (this.plugin.getHologramManager().hasHologram(args[2])) {
                    sender.sendMessage(TextUtil.replace(Message.HOLOGRAMS_ALREADY_EXISTS.toComponent(), "name", TextUtil.parse(args[2])));
                    return;
                }
                holo = this.plugin.getHologramManager().createHologram(args[2], player.getLocation());
                ArrayList<Component> defaultMsg = new ArrayList<Component>();
                defaultMsg.add(TextUtil.parse("<gray>Created new Hologram called <aqua>" + args[2]));
                defaultMsg.add(TextUtil.parse("<gray>Use <aqua>/akropolis holo <gray>to customise"));
                holo.setLines(defaultMsg);
                Message.HOLOGRAMS_SPAWNED.sendWithReplacement((Audience)sender, "name", TextUtil.parse(args[2]));
                return;
            }
            if (args[1].equalsIgnoreCase("remove") || args[1].equalsIgnoreCase("delete")) {
                if (args.length == 2) {
                    Message.USAGE.sendWithReplacement((Audience)sender, "command", (Component)Component.text((String)"akropolis hologram remove <id>"));
                    return;
                }
                if (!this.plugin.getHologramManager().hasHologram(args[2])) {
                    sender.sendMessage(TextUtil.replace(Message.HOLOGRAMS_INVALID_HOLOGRAM.toComponent(), "name", TextUtil.parse(args[2])));
                    return;
                }
                this.plugin.getHologramManager().deleteHologram(args[2]);
                Message.HOLOGRAMS_DESPAWNED.sendWithReplacement((Audience)sender, "name", TextUtil.parse(args[2]));
                return;
            }
            if (args[1].equalsIgnoreCase("setline")) {
                if (args.length < 5) {
                    Message.USAGE.sendWithReplacement((Audience)sender, "command", (Component)Component.text((String)"akropolis hologram setline <id> <line> <text>"));
                    return;
                }
                if (!this.plugin.getHologramManager().hasHologram(args[2])) {
                    sender.sendMessage(TextUtil.replace(Message.HOLOGRAMS_INVALID_HOLOGRAM.toComponent(), "name", TextUtil.parse(args[2])));
                    return;
                }
                holo = this.plugin.getHologramManager().getHologram(args[2]);
                int line = Integer.parseInt(args[3]);
                String text = TextUtil.joinString(4, args);
                if (holo.hasInvalidLine(line)) {
                    sender.sendMessage(TextUtil.replace(Message.HOLOGRAMS_INVALID_LINE.toComponent(), "line", TextUtil.parse(String.valueOf(line))));
                    return;
                }
                holo.setLine(line, TextUtil.parse(text));
                Message.HOLOGRAMS_LINE_SET.sendWithReplacement((Audience)sender, "line", TextUtil.parse(String.valueOf(line)));
                return;
            }
            if (args[1].equalsIgnoreCase("addline")) {
                if (args.length <= 3) {
                    Message.USAGE.sendWithReplacement((Audience)sender, "command", (Component)Component.text((String)"akropolis hologram addline <id> <text>"));
                    return;
                }
                if (!this.plugin.getHologramManager().hasHologram(args[2])) {
                    sender.sendMessage(TextUtil.replace(Message.HOLOGRAMS_INVALID_HOLOGRAM.toComponent(), "name", TextUtil.parse(args[2])));
                    return;
                }
                holo = this.plugin.getHologramManager().getHologram(args[2]);
                Component text = TextUtil.parse(TextUtil.joinString(3, args));
                holo.addLine(text);
                Message.HOLOGRAMS_ADDED_LINE.sendWithReplacement((Audience)sender, "name", TextUtil.parse(args[2]));
            }
            if (args[1].equalsIgnoreCase("removeline")) {
                int line;
                if (args.length != 4) {
                    Message.USAGE.sendWithReplacement((Audience)sender, "command", (Component)Component.text((String)"akropolis hologram removeline <id> <line>"));
                    return;
                }
                if (!this.plugin.getHologramManager().hasHologram(args[2])) {
                    sender.sendMessage(TextUtil.replace(Message.HOLOGRAMS_INVALID_HOLOGRAM.toComponent(), "name", TextUtil.parse(args[2])));
                    return;
                }
                holo = this.plugin.getHologramManager().getHologram(args[2]);
                if (holo.hasInvalidLine(line = Integer.parseInt(args[3]))) {
                    sender.sendMessage(TextUtil.replace(Message.HOLOGRAMS_INVALID_LINE.toComponent(), "line", TextUtil.parse(String.valueOf(line))));
                    return;
                }
                if (holo.removeLine(line) == null) {
                    this.plugin.getHologramManager().deleteHologram(args[2]);
                    sender.sendMessage(TextUtil.replace(Message.HOLOGRAMS_REMOVED_LINE.toComponent(), "name", TextUtil.parse(args[2])));
                }
                return;
            }
            if (args[1].equalsIgnoreCase("move")) {
                if (args.length == 2) {
                    Message.USAGE.sendWithReplacement((Audience)sender, "command", (Component)Component.text((String)"akropolis hologram move <id>"));
                    return;
                }
                if (!this.plugin.getHologramManager().hasHologram(args[2])) {
                    sender.sendMessage(TextUtil.replace(Message.HOLOGRAMS_INVALID_HOLOGRAM.toComponent(), "name", TextUtil.parse(args[2])));
                    return;
                }
                holo = this.plugin.getHologramManager().getHologram(args[2]);
                holo.setLocation(player.getLocation());
                Message.HOLOGRAMS_MOVED.sendWithReplacement((Audience)sender, "name", TextUtil.parse(args[2]));
            }
        }
        if (args[0].equalsIgnoreCase("songplayer") || args[0].equalsIgnoreCase("sp")) {
            if (!(sender instanceof Player)) {
                Message.CONSOLE_NOT_ALLOWED.send((Audience)sender);
                return;
            }
            Player player = (Player)sender;
            if (!sender.hasPermission(Permissions.COMMAND_SONG_PLAYER.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            if (args.length == 1) {
                Message.HELP_SONG_PLAYER.toComponentList().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                return;
            }
            SongPlayerManager songPlayerManager = this.plugin.getSongPlayerManager();
            if (songPlayerManager.getSongPlayer() == null) {
                Message.SONG_PLAYER_NOT_LOADED.send((Audience)sender);
                return;
            }
            if (args[1].equalsIgnoreCase("setpos")) {
                songPlayerManager.setLocation(player.getLocation());
                Message.SONG_PLAYER_SET_LOCATION.send((Audience)sender);
            }
            if (args[1].equalsIgnoreCase("skip")) {
                songPlayerManager.skip();
                Bukkit.getScheduler().runTaskLaterAsynchronously(this.getPlugin(), () -> Message.SONG_PLAYER_SKIPPED.sendWithReplacement((Audience)sender, "current_song", TextUtil.parse(songPlayerManager.getCurrentSong())), 20L);
            }
        }
    }
}

