/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis;

import java.util.logging.Level;
import me.zetastormy.akropolis.action.ActionManager;
import me.zetastormy.akropolis.command.CommandManager;
import me.zetastormy.akropolis.config.ConfigManager;
import me.zetastormy.akropolis.cooldown.CooldownManager;
import me.zetastormy.akropolis.hook.HooksManager;
import me.zetastormy.akropolis.inventory.InventoryManager;
import me.zetastormy.akropolis.libs.scoreboardlibrary.api.ScoreboardLibrary;
import me.zetastormy.akropolis.libs.scoreboardlibrary.api.exception.NoPacketAdapterAvailableException;
import me.zetastormy.akropolis.libs.scoreboardlibrary.api.noop.NoopScoreboardLibrary;
import me.zetastormy.akropolis.module.ModuleManager;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.hologram.HologramManager;
import me.zetastormy.akropolis.module.modules.player.FightModeManager;
import me.zetastormy.akropolis.module.modules.world.SongPlayerManager;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AkropolisPlugin
extends JavaPlugin {
    private static AkropolisPlugin plugin;
    private ConfigManager configManager;
    private ActionManager actionManager;
    private HooksManager hooksManager;
    private CommandManager commandManager;
    private CooldownManager cooldownManager;
    private ModuleManager moduleManager;
    private InventoryManager inventoryManager;
    private ScoreboardLibrary scoreboardLibrary;

    public void onEnable() {
        AkropolisPlugin.setInstance(this);
        long start = System.currentTimeMillis();
        this.getLogger().log(Level.INFO, "     _    _                          _ _     ");
        this.getLogger().log(Level.INFO, "    / \\  | | ___ __ ___  _ __   ___ | (_)___ ");
        this.getLogger().log(Level.INFO, "   / _ \\ | |/ / '__/ _ \\| '_ \\ / _ \\| | / __|");
        this.getLogger().log(Level.INFO, "  / ___ \\|   <| | | (_) | |_) | (_) | | \\__ \\");
        this.getLogger().log(Level.INFO, " /_/   \\_\\_|\\_\\_|  \\___/| .__/ \\___/|_|_|___/");
        this.getLogger().log(Level.INFO, "                        |_|                  ");
        this.getLogger().log(Level.INFO, "Author: ZetaStormy");
        this.getLogger().log(Level.INFO, "Based on DeluxeHub by ItsLewizzz.");
        this.getLogger().log(Level.INFO, "--------");
        this.hooksManager = new HooksManager(this);
        this.configManager = new ConfigManager();
        this.configManager.loadFiles(this);
        if (!this.getServer().getPluginManager().isPluginEnabled((Plugin)this)) {
            return;
        }
        this.commandManager = new CommandManager(this);
        this.commandManager.reload();
        this.cooldownManager = new CooldownManager();
        try {
            this.scoreboardLibrary = ScoreboardLibrary.loadScoreboardLibrary((Plugin)plugin);
        }
        catch (NoPacketAdapterAvailableException e) {
            this.scoreboardLibrary = new NoopScoreboardLibrary();
        }
        this.moduleManager = new ModuleManager();
        this.moduleManager.loadModules(this);
        this.inventoryManager = new InventoryManager();
        if (!this.hooksManager.isHookEnabled("HEAD_DATABASE")) {
            this.inventoryManager.onEnable(this);
        }
        this.actionManager = new ActionManager(this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.getLogger().log(Level.INFO, "Successfully loaded in {0}ms.", System.currentTimeMillis() - start);
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.moduleManager != null) {
            this.moduleManager.unloadModules();
        }
        if (this.scoreboardLibrary != null) {
            this.scoreboardLibrary.close();
        }
        if (this.inventoryManager != null) {
            this.inventoryManager.onDisable();
        }
        if (this.configManager != null) {
            this.configManager.saveData();
        }
    }

    public void reload() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        this.configManager.reloadFiles();
        this.inventoryManager.onDisable();
        this.inventoryManager.onEnable(this);
        this.scoreboardLibrary.close();
        try {
            this.commandManager.reload();
            ((CraftServer)this.getServer()).syncCommands();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.scoreboardLibrary = ScoreboardLibrary.loadScoreboardLibrary((Plugin)plugin);
        }
        catch (NoPacketAdapterAvailableException e) {
            this.scoreboardLibrary = new NoopScoreboardLibrary();
        }
        this.moduleManager.loadModules(this);
    }

    public static synchronized void setInstance(AkropolisPlugin instance) {
        if (plugin == null) {
            plugin = instance;
        }
    }

    public static synchronized AkropolisPlugin getInstance() {
        return plugin;
    }

    public FightModeManager getFightModeManager() {
        return (FightModeManager)this.moduleManager.getModule(ModuleType.FIGHT_MODE);
    }

    public SongPlayerManager getSongPlayerManager() {
        return (SongPlayerManager)this.moduleManager.getModule(ModuleType.SONG_PLAYER);
    }

    public HologramManager getHologramManager() {
        return (HologramManager)this.moduleManager.getModule(ModuleType.HOLOGRAMS);
    }

    public HooksManager getHookManager() {
        return this.hooksManager;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public ScoreboardLibrary getScoreboardLibrary() {
        return this.scoreboardLibrary;
    }
}

