/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class PacketUtil {
    private static final MethodHandle GET_HANDLE;
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle SEND_PACKET;

    private PacketUtil() {
    }

    public static void sendPacket(Player player, Packet<?> packet) {
        try {
            ServerPlayer handle = GET_HANDLE.invoke(player);
            ServerGamePacketListenerImpl connection = PLAYER_CONNECTION.invoke(handle);
            SEND_PACKET.invoke(connection, packet);
        }
        catch (Throwable e) {
            throw new IllegalStateException("couldn't send packet to player", e);
        }
    }

    static {
        String[] sendPacketNames;
        Class<?> craftPlayer;
        String cbPackage = Bukkit.getServer().getClass().getPackage().getName();
        try {
            craftPlayer = Class.forName(cbPackage + ".entity.CraftPlayer");
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodType methodType = MethodType.methodType(ServerPlayer.class);
        try {
            GET_HANDLE = lookup.findVirtual(craftPlayer, "getHandle", methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        MethodHandle playerConnection = null;
        for (Field field : ServerPlayer.class.getFields()) {
            if (field.getType() != ServerGamePacketListenerImpl.class) continue;
            try {
                playerConnection = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
        if (playerConnection == null) {
            throw new ExceptionInInitializerError("failed to find player connection field");
        }
        PLAYER_CONNECTION = playerConnection;
        MethodType sendMethodType = MethodType.methodType(Void.TYPE, Packet.class);
        MethodHandle sendPacket = null;
        for (String name : sendPacketNames = new String[]{"a", "sendPacket", "b", "send"}) {
            try {
                sendPacket = lookup.findVirtual(ServerGamePacketListenerImpl.class, name, sendMethodType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
        if (sendPacket == null) {
            throw new ExceptionInInitializerError(new RuntimeException("Couldn't find send packet method"));
        }
        SEND_PACKET = sendPacket;
    }
}

