/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.api.objective;

import com.google.common.base.Preconditions;
import net.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface ObjectiveDisplaySlot {
    @NotNull
    public static PlayerList playerList() {
        return PlayerList.INSTANCE;
    }

    @NotNull
    public static Sidebar sidebar() {
        return Sidebar.INSTANCE;
    }

    @NotNull
    public static BelowName belowName() {
        return BelowName.INSTANCE;
    }

    @NotNull
    public static TeamSidebar teamSidebar(@NotNull NamedTextColor teamColor) {
        Preconditions.checkNotNull((Object)teamColor);
        return new TeamSidebar(teamColor);
    }

    public static class PlayerList
    implements ObjectiveDisplaySlot {
        private static final PlayerList INSTANCE = new PlayerList();

        private PlayerList() {
        }

        public String toString() {
            return "PlayerList";
        }
    }

    public static class Sidebar
    implements ObjectiveDisplaySlot {
        private static final Sidebar INSTANCE = new Sidebar();

        private Sidebar() {
        }

        public String toString() {
            return "Sidebar";
        }
    }

    public static class BelowName
    implements ObjectiveDisplaySlot {
        private static final BelowName INSTANCE = new BelowName();

        private BelowName() {
        }

        public String toString() {
            return "BelowName";
        }
    }

    public static class TeamSidebar
    implements ObjectiveDisplaySlot {
        private final NamedTextColor teamColor;

        private TeamSidebar(@NotNull NamedTextColor teamColor) {
            this.teamColor = teamColor;
        }

        @NotNull
        public NamedTextColor teamColor() {
            return this.teamColor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TeamSidebar that = (TeamSidebar)o;
            return this.teamColor.equals(that.teamColor);
        }

        public int hashCode() {
            return this.teamColor.hashCode();
        }

        public String toString() {
            return "TeamSidebar{teamColor=" + this.teamColor + "}";
        }
    }
}

