/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.player;

import java.util.ArrayList;
import java.util.List;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.Permissions;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;

public class PlayerListener
extends Module
implements LifeCycle {
    private ConfigurationSection playersSection;
    private boolean joinQuitMessagesEnabled;
    private String joinMessage;
    private String quitMessage;
    private List<String> joinActions;
    private int focusedSlot;
    private boolean spawnHeal;
    private boolean extinguish;
    private boolean clearInventory;
    private boolean fireworkEnabled;
    private boolean fireworkFirstJoin;
    private boolean fireworkFlicker;
    private boolean fireworkTrail;
    private int fireworkPower;
    private String fireworkType;
    private List<Color> fireworkColors;
    private boolean forceJoinFly;

    public PlayerListener(AkropolisPlugin plugin) {
        super(plugin, ModuleType.PLAYER_LISTENER);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.playersSection = this.getConfig(ConfigType.DATA).getConfigurationSection("players");
        this.joinQuitMessagesEnabled = config.getBoolean("join_leave_messages.enabled");
        this.joinMessage = config.getString("join_leave_messages.join_message");
        this.quitMessage = config.getString("join_leave_messages.quit_message");
        this.joinActions = config.getStringList("join_events");
        this.focusedSlot = config.getInt("join_settings.focused_slot", 0);
        this.spawnHeal = config.getBoolean("join_settings.heal", false);
        this.extinguish = config.getBoolean("join_settings.extinguish", false);
        this.clearInventory = config.getBoolean("join_settings.clear_inventory", false);
        this.forceJoinFly = config.getBoolean("fly.force_on_join", false);
        this.fireworkEnabled = config.getBoolean("join_settings.firework.enabled", true);
        if (this.fireworkEnabled) {
            this.fireworkFirstJoin = config.getBoolean("join_settings.firework.first_join_only", true);
            this.fireworkType = config.getString("join_settings.firework.type", "BALL_LARGE");
            this.fireworkPower = config.getInt("join_settings.firework.power", 1);
            this.fireworkFlicker = config.getBoolean("join_settings.firework.flicker", true);
            this.fireworkTrail = config.getBoolean("join_settings.firework.power", true);
            this.fireworkColors = new ArrayList<Color>();
            config.getStringList("join_settings.firework.colors").forEach(c -> {
                Color color = TextUtil.getColor(c);
                if (color != null) {
                    this.fireworkColors.add(color);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        if (this.joinQuitMessagesEnabled) {
            if (this.joinMessage.isEmpty()) {
                event.joinMessage(null);
            } else {
                Component message = PlaceholderUtil.setPlaceholders(this.joinMessage, (Audience)player);
                event.joinMessage(message);
            }
        }
        if (this.focusedSlot != -1) {
            player.getInventory().setHeldItemSlot(this.focusedSlot);
        }
        if (this.spawnHeal) {
            Attribute legacyMaxHealth;
            player.setFoodLevel(20);
            Attribute maxHealthAttribute = legacyMaxHealth = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.max_health"));
            if (legacyMaxHealth == null) {
                maxHealthAttribute = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"max_health"));
            }
            if (maxHealthAttribute == null) {
                return;
            }
            AttributeInstance maxHealth = player.getAttribute(maxHealthAttribute);
            if (maxHealth == null) {
                return;
            }
            player.setHealth(maxHealth.getBaseValue());
        }
        if (this.extinguish) {
            player.setFireTicks(0);
        }
        if (this.clearInventory) {
            player.getInventory().clear();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> {
            this.executeActions(player, this.joinActions);
            if (this.playersSection != null && this.playersSection.contains(player.getUniqueId().toString())) {
                boolean hasFly = this.playersSection.getBoolean(String.valueOf(player.getUniqueId()) + ".fly");
                player.setAllowFlight(hasFly);
                player.setFlying(hasFly);
            } else if (this.forceJoinFly && player.hasPermission(Permissions.COMMAND_FLIGHT.getPermission())) {
                player.setAllowFlight(true);
                player.setFlying(true);
            }
            if (this.fireworkEnabled) {
                if (this.fireworkFirstJoin) {
                    if (!player.hasPlayedBefore()) {
                        this.spawnFirework(player);
                    }
                } else {
                    this.spawnFirework(player);
                }
            }
        }, 3L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        if (this.joinQuitMessagesEnabled) {
            if (this.quitMessage.isEmpty()) {
                event.quitMessage((Component)Component.empty());
            } else {
                Component message = PlaceholderUtil.setPlaceholders(this.quitMessage, (Audience)player);
                event.quitMessage(message);
            }
        }
        player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
        }
    }

    public void spawnFirework(Player player) {
        Firework f = (Firework)player.getWorld().spawn(player.getLocation(), Firework.class);
        FireworkMeta fm = f.getFireworkMeta();
        fm.addEffect(FireworkEffect.builder().flicker(this.fireworkFlicker).trail(this.fireworkTrail).with(FireworkEffect.Type.valueOf((String)this.fireworkType)).withColor(this.fireworkColors).build());
        fm.setPower(this.fireworkPower);
        f.setFireworkMeta(fm);
    }
}

