/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.player;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.util.ItemStackBuilder;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FightModeManager
extends Module
implements LifeCycle {
    private final Map<UUID, Integer> holdTasks = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> holdTimers = new HashMap<UUID, Integer>();
    private final Set<UUID> fighters = new HashSet<UUID>();
    private ItemStack helmet;
    private ItemStack chestplate;
    private ItemStack leggings;
    private ItemStack boots;
    private int activateDelay;
    private int deactivateDelay;
    private List<String> countdownActions;
    private List<String> activatedActions;
    private List<String> deactivatedActions;

    public FightModeManager(AkropolisPlugin plugin) {
        super(plugin, ModuleType.FIGHT_MODE);
    }

    @Override
    public void onEnable() {
        ConfigurationSection conf = this.getConfig(ConfigType.SETTINGS).getConfigurationSection("fight_mode");
        ItemStack helmet = ItemStackBuilder.getItemStack(conf.getConfigurationSection("armor.helmet")).build();
        ItemStack chestplate = ItemStackBuilder.getItemStack(conf.getConfigurationSection("armor.chestplate")).build();
        ItemStack leggings = ItemStackBuilder.getItemStack(conf.getConfigurationSection("armor.leggings")).build();
        ItemStack boots = ItemStackBuilder.getItemStack(conf.getConfigurationSection("armor.boots")).build();
        int activateDelay = conf.getInt("hold_delay.activate");
        int deactivateDelay = conf.getInt("hold_delay.deactivate");
        List countdownActions = conf.getStringList("actions.countdown");
        List activatedActions = conf.getStringList("actions.activated");
        List deactivatedActions = conf.getStringList("actions.deactivated");
        this.helmet = helmet;
        this.chestplate = chestplate;
        this.leggings = leggings;
        this.boots = boots;
        this.activateDelay = activateDelay;
        this.deactivateDelay = deactivateDelay;
        this.countdownActions = countdownActions;
        this.activatedActions = activatedActions;
        this.deactivatedActions = deactivatedActions;
    }

    @Override
    public void onDisable() {
        this.holdTasks.clear();
        this.holdTimers.clear();
        this.fighters.clear();
    }

    public void startActivationTimer(Player player) {
        UUID playerUuid = player.getUniqueId();
        this.holdTimers.put(playerUuid, 0);
        int taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), () -> {
            int time = this.holdTimers.get(playerUuid);
            ItemStack currentItem = player.getInventory().getItemInMainHand();
            if (!this.isValidItem(currentItem)) {
                this.cancelHoldTask(playerUuid);
                return;
            }
            if (time >= this.activateDelay) {
                this.enableFightMode(player);
                this.cancelHoldTask(playerUuid);
                return;
            }
            TextComponent timeLeft = Component.text((int)(this.activateDelay - time));
            this.executeActions(player, this.countdownActions);
            Message.FIGHT_MODE_ACTIVATE_DELAY.sendWithReplacement((Audience)player, "seconds", (Component)timeLeft);
            this.holdTimers.put(playerUuid, time + 1);
        }, 0L, 20L);
        this.holdTasks.put(playerUuid, taskId);
    }

    public void startDeactivationTimer(Player player) {
        UUID playerUuid = player.getUniqueId();
        this.holdTimers.put(playerUuid, 0);
        int taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), () -> {
            int time = this.holdTimers.get(playerUuid);
            ItemStack currentItem = player.getInventory().getItemInMainHand();
            if (this.isValidItem(currentItem)) {
                this.cancelHoldTask(playerUuid);
                return;
            }
            if (time >= this.deactivateDelay) {
                this.disableFightMode(player);
                this.cancelHoldTask(playerUuid);
                return;
            }
            TextComponent timeLeft = Component.text((int)(this.deactivateDelay - time));
            this.executeActions(player, this.countdownActions);
            Message.FIGHT_MODE_DEACTIVATE_DELAY.sendWithReplacement((Audience)player, "seconds", (Component)timeLeft);
            this.holdTimers.put(playerUuid, time + 1);
        }, 0L, 20L);
        this.holdTasks.put(playerUuid, taskId);
    }

    public boolean isValidItem(ItemStack item) {
        if (item == null || item.getItemMeta() == null) {
            return false;
        }
        String key = (String)item.getItemMeta().getPersistentDataContainer().get(NamespacedKey.minecraft((String)"hotbar-item"), PersistentDataType.STRING);
        return key == null ? false : key.equals("FIGHT_MODE_ITEM");
    }

    public void cancelHoldTask(UUID playerUuid) {
        if (this.holdTasks.containsKey(playerUuid)) {
            Bukkit.getScheduler().cancelTask(this.holdTasks.get(playerUuid).intValue());
            this.holdTasks.remove(playerUuid);
        }
    }

    public boolean hasHoldTask(UUID playerUuid) {
        return this.holdTasks.containsKey(playerUuid);
    }

    public void enableFightMode(Player player) {
        if (this.isInFightMode(player.getUniqueId())) {
            return;
        }
        this.giveArmor(player);
        this.fighters.add(player.getUniqueId());
        this.executeActions(player, this.activatedActions);
    }

    public void disableFightMode(Player player) {
        if (!this.isInFightMode(player.getUniqueId())) {
            return;
        }
        this.removeArmor(player);
        this.fighters.remove(player.getUniqueId());
        this.executeActions(player, this.deactivatedActions);
    }

    public boolean isInFightMode(UUID playerUuid) {
        return this.fighters.contains(playerUuid);
    }

    private void giveArmor(Player player) {
        PlayerInventory playerInventory = player.getInventory();
        playerInventory.setHelmet(this.helmet);
        playerInventory.setChestplate(this.chestplate);
        playerInventory.setLeggings(this.leggings);
        playerInventory.setBoots(this.boots);
    }

    private void removeArmor(Player player) {
        PlayerInventory playerInventory = player.getInventory();
        playerInventory.setHelmet(null);
        playerInventory.setChestplate(null);
        playerInventory.setLeggings(null);
        playerInventory.setBoots(null);
    }
}

