/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.hotbar.items;

import java.util.Collections;
import java.util.List;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarItem;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarManager;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CustomItem
extends HotbarItem {
    private final String key;
    private final int cooldown;
    private final List<String> actions;

    public CustomItem(HotbarManager hotbarManager, ItemStack item, int slot, String key) {
        super(hotbarManager, item, slot, key);
        this.key = key;
        ConfigurationSection itemSettings = this.getPlugin().getConfigManager().getFile(ConfigType.SETTINGS).get().getConfigurationSection("custom_join_items.items." + key);
        if (itemSettings == null) {
            this.cooldown = 0;
            this.actions = Collections.emptyList();
            return;
        }
        this.cooldown = itemSettings.getInt("cooldown", 0);
        this.actions = itemSettings.getStringList("actions");
    }

    @Override
    protected void onInteract(Player player) {
        if (!this.getHotbarManager().tryCooldown(player.getUniqueId(), this.key, this.cooldown)) {
            Message.COOLDOWN_ACTIVE.sendWithReplacement((Audience)player, "time", (Component)Component.text((long)this.getHotbarManager().getCooldown(player.getUniqueId(), this.key)));
            return;
        }
        this.getPlugin().getActionManager().executeActions(player, this.actions);
    }
}

