/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.chat.groups;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.chat.groups.ChatGroup;
import me.zetastormy.akropolis.module.modules.chat.groups.Emojis;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class ChatGroups
extends Module
implements LifeCycle {
    private final Map<String, ChatGroup> chatGroups = new HashMap<String, ChatGroup>();

    public ChatGroups(AkropolisPlugin plugin) {
        super(plugin, ModuleType.CHAT_FORMAT);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        ConfigurationSection groupsSection = config.getConfigurationSection("groups");
        if (groupsSection == null) {
            this.getPlugin().getLogger().info("Skipping chat groups creation, configuration section is missing!");
            return;
        }
        groupsSection.getKeys(false).stream().filter(key -> !key.equals("enabled")).forEach(groupName -> this.chatGroups.put((String)groupName, new ChatGroup((String)groupName, groupsSection.getString(groupName + ".format", String.format("<red><bold>[Akropolis]</bold> Chat group <yellow>%s</yellow> has no format, check the configuration.", groupName)), groupsSection.getInt(groupName + ".priority", 0), groupsSection.getInt(groupName + ".cooldown.time", 0), groupsSection.getString(groupName + ".cooldown.message", String.format("<red><bold>[Akropolis]</bold> Chat group <yellow>%s</yellow> has no cooldown message, check the configuration.", groupName)), new Emojis(groupsSection.getConfigurationSection(groupName + ".emojis")))));
    }

    @Override
    public void onDisable() {
        this.chatGroups.clear();
    }

    @EventHandler
    public void onPlayerChat(AsyncChatEvent event) {
        String rawMessage;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        HashSet<ChatGroup> playerGroups = new HashSet<ChatGroup>();
        ChatGroup topGroup = null;
        for (String group : this.chatGroups.keySet()) {
            if (!player.hasPermission("akropolis.chat.group." + group)) continue;
            playerGroups.add(this.chatGroups.get(group));
            if (topGroup != null && this.chatGroups.get(group).getPriority() < topGroup.getPriority()) continue;
            topGroup = this.chatGroups.get(group);
        }
        if (topGroup == null) {
            return;
        }
        event.setCancelled(true);
        if (!this.tryCooldown(player.getUniqueId(), "chat", topGroup.getCooldownTime())) {
            player.sendMessage(TextUtil.replace(topGroup.getCooldownMessage(), "time", (Component)Component.text((long)this.getCooldown(player.getUniqueId(), "chat"))));
            return;
        }
        String parsedMessageEmojis = rawMessage = TextUtil.raw(event.originalMessage());
        for (ChatGroup group : playerGroups) {
            parsedMessageEmojis = group.parseEmojis(parsedMessageEmojis);
        }
        String parsedMessage = TextUtil.raw((Component)LegacyComponentSerializer.legacySection().deserialize(ChatColor.translateAlternateColorCodes((char)'&', (String)parsedMessageEmojis)));
        this.getPlugin().getServer().sendMessage(TextUtil.replace(topGroup.getFormat(player), "message", TextUtil.parse(parsedMessage)));
    }
}

