/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.hook.hooks.head;

import com.cryptomorin.xseries.XMaterial;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.hook.PluginHook;
import me.zetastormy.akropolis.hook.hooks.head.HeadHook;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;

public class BaseHead
implements PluginHook,
HeadHook {
    private AkropolisPlugin plugin;
    private Map<String, ItemStack> cache;

    @Override
    public void onEnable(AkropolisPlugin plugin) {
        this.plugin = plugin;
        this.cache = new HashMap<String, ItemStack>();
    }

    @Override
    public ItemStack getHead(String data) {
        if (this.cache.containsKey(data)) {
            return this.cache.get(data);
        }
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        if (head == null) {
            this.plugin.getLogger().severe("Could not parse head!");
            return XMaterial.SKELETON_SKULL.parseItem();
        }
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta == null) {
            this.plugin.getLogger().severe("Could not parse head meta!");
            return head;
        }
        head.editMeta(SkullMeta.class, skullMeta -> {
            PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID(), null);
            Set properties = profile.getProperties();
            properties.clear();
            properties.add(new ProfileProperty("textures", data, ""));
            profile.setProperties((Collection)properties);
            skullMeta.setPlayerProfile(profile);
        });
        this.cache.put(data, head);
        return head;
    }
}

