/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.cooldown;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.UUID;

public class CooldownManager {
    private final Table<String, String, Long> cooldowns = HashBasedTable.create();

    public long getCooldown(UUID uuid, String key) {
        return this.calculateRemainder((Long)this.cooldowns.get((Object)uuid.toString(), (Object)key));
    }

    public void setCooldown(UUID uuid, String key, long delay) {
        this.calculateRemainder((Long)this.cooldowns.put((Object)uuid.toString(), (Object)key, (Object)(System.currentTimeMillis() + delay * 1000L)));
    }

    public boolean tryCooldown(UUID uuid, String key, long delay) {
        if (this.getCooldown(uuid, key) / 1000L > 0L) {
            return false;
        }
        this.setCooldown(uuid, key, delay + 1L);
        return true;
    }

    private long calculateRemainder(Long expireTime) {
        return expireTime != null ? expireTime - System.currentTimeMillis() : Long.MIN_VALUE;
    }
}

